/*
 * Decompiled with CFR 0.152.
 */
package com.thejebforge.trickster_lisp.transpiler.ast;

import com.thejebforge.trickster_lisp.transpiler.LispUtils;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpressionType;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.Objects;

public class IntegerValue
extends SExpression {
    public static final StructEndec<IntegerValue> ENDEC = StructEndecBuilder.of((StructField)StructEndec.INT.fieldOf("v", IntegerValue::getNumber), IntegerValue::new);
    private int number;

    public IntegerValue(int number) {
        this.number = number;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntegerValue)) {
            return false;
        }
        IntegerValue that = (IntegerValue)o;
        return this.number == that.number;
    }

    public int hashCode() {
        return Objects.hashCode(this.number);
    }

    public String toString() {
        return "Integer{\nnumber=" + this.number + "\n}";
    }

    @Override
    public SExpressionType<?> type() {
        return SExpressionType.INTEGER;
    }

    @Override
    public SExpression deepCopy() {
        return new IntegerValue(this.number);
    }

    @Override
    public boolean shallowEquals(SExpression other) {
        return this.equals(other);
    }

    @Override
    public String toCode(int indent, int tabSize, boolean inline) {
        return LispUtils.addIndent(indent, inline) + this.number;
    }
}

