/*
 * Decompiled with CFR 0.152.
 */
package com.thejebforge.trickster_lisp.transpiler.ast;

import com.thejebforge.trickster_lisp.transpiler.LispUtils;
import com.thejebforge.trickster_lisp.transpiler.ast.Call;
import com.thejebforge.trickster_lisp.transpiler.ast.ExpressionList;
import com.thejebforge.trickster_lisp.transpiler.ast.Greedy;
import com.thejebforge.trickster_lisp.transpiler.ast.Identifier;
import com.thejebforge.trickster_lisp.transpiler.ast.MapExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.PreProcessor;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.MacroCallBuilder;
import com.thejebforge.trickster_lisp.transpiler.util.CallUtils;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class Macro
extends PreProcessor {
    public static final StructEndec<Macro> ENDEC = StructEndecBuilder.of((StructField)StructEndec.STRING.fieldOf("name", Macro::getName), (StructField)StructEndec.STRING.listOf().fieldOf("args", Macro::getArguments), (StructField)StructEndec.BOOLEAN.fieldOf("greedy", Macro::isGreedy), (StructField)SExpression.ENDEC.fieldOf("subst", Macro::getSubstitute), Macro::new);
    private String name;
    private List<String> arguments;
    private boolean greedy;
    private SExpression substitute;

    public Macro(String name, List<String> arguments, boolean greedy, SExpression substitute) {
        this.name = name;
        this.arguments = arguments;
        this.greedy = greedy;
        this.substitute = substitute;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public boolean isGreedy() {
        return this.greedy;
    }

    public void setGreedy(boolean greedy) {
        this.greedy = greedy;
    }

    public SExpression getSubstitute() {
        return this.substitute;
    }

    public void setSubstitute(SExpression substitute) {
        this.substitute = substitute;
    }

    private Stream<SExpression> findAndReplace(SExpression current, List<SExpression> substitutions) {
        SExpression sExpression = current;
        Objects.requireNonNull(sExpression);
        SExpression sExpression2 = sExpression;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Identifier.class, Call.class, ExpressionList.class, MapExpression.class, Greedy.class}, (Object)sExpression2, n)) {
            case 0: {
                Identifier id = (Identifier)sExpression2;
                int argumentIndex = this.arguments.indexOf(id.getName());
                if (argumentIndex != -1) {
                    return Stream.of(substitutions.get(argumentIndex).deepCopy());
                }
                return Stream.of(id);
            }
            case 1: {
                Call call = (Call)sExpression2;
                return Stream.of(new Call(this.findAndReplace(call.getSubject(), substitutions).findFirst().orElseThrow(), call.getArguments().stream().flatMap(e -> this.findAndReplace((SExpression)e, substitutions)).toList()));
            }
            case 2: {
                ExpressionList list = (ExpressionList)sExpression2;
                return Stream.of(new ExpressionList(list.getExpressions().stream().flatMap(e -> this.findAndReplace((SExpression)e, substitutions)).toList()));
            }
            case 3: {
                MapExpression map = (MapExpression)sExpression2;
                HashMap<SExpression, SExpression> newMap = new HashMap<SExpression, SExpression>();
                map.getExpressionMap().forEach((k, v) -> newMap.put(this.findAndReplace((SExpression)k, substitutions).findFirst().orElseThrow(() -> CallUtils.getConversionError(k, "This should never happen")), this.findAndReplace((SExpression)v, substitutions).findFirst().orElseThrow(() -> CallUtils.getConversionError(k, "This should never happen"))));
                return Stream.of(new MapExpression(newMap));
            }
            case 4: {
                Greedy ignored = (Greedy)sExpression2;
                return substitutions.stream().skip(this.arguments.size());
            }
        }
        return Stream.of(current);
    }

    public SExpression apply(SExpression parent, List<SExpression> args) {
        if (this.arguments.size() != args.size() && !this.greedy) {
            throw CallUtils.getConversionError(parent, "Invalid amount of arguments passed to macro call, expected " + this.arguments.size() + " arguments, got " + args.size());
        }
        return this.findAndReplace(this.substitute.deepCopy(), args).findFirst().orElseThrow();
    }

    private boolean greedyMatchAndCollect(List<SExpression> expressions, List<SExpression> substitutions, Map<String, List<SExpression>> collectedArgs) {
        boolean encounteredGreedyBefore = collectedArgs.containsKey("...");
        int substituteIndex = 0;
        boolean gotGreedy = false;
        for (SExpression expression : expressions) {
            if (substituteIndex > substitutions.size()) {
                return false;
            }
            if (substituteIndex < substitutions.size() && substitutions.get(substituteIndex) instanceof Greedy && !gotGreedy) {
                gotGreedy = true;
                collectedArgs.putIfAbsent("...", new ArrayList());
                ++substituteIndex;
            }
            if (gotGreedy) {
                if (substituteIndex < substitutions.size() && this.matchAndCollect(expression, substitutions.get(substituteIndex), collectedArgs)) {
                    gotGreedy = false;
                    ++substituteIndex;
                    continue;
                }
                if (encounteredGreedyBefore) {
                    if (collectedArgs.get("...").contains(expression)) continue;
                    return false;
                }
                collectedArgs.get("...").add(expression);
                continue;
            }
            if (substituteIndex >= substitutions.size() || !this.matchAndCollect(expression, substitutions.get(substituteIndex), collectedArgs)) {
                return false;
            }
            ++substituteIndex;
        }
        return substituteIndex == substitutions.size();
    }

    private boolean matchAndCollect(SExpression expression, SExpression substitute, Map<String, List<SExpression>> collectedArgs) {
        Identifier id;
        if (substitute instanceof Identifier && this.arguments.contains((id = (Identifier)substitute).getName())) {
            if (collectedArgs.containsKey(id.getName())) {
                return collectedArgs.get(id.getName()).contains(expression);
            }
            collectedArgs.putIfAbsent(id.getName(), new ArrayList());
            collectedArgs.get(id.getName()).add(expression);
            return true;
        }
        if (!expression.shallowEquals(substitute)) {
            return false;
        }
        SExpression sExpression = expression;
        Objects.requireNonNull(sExpression);
        SExpression sExpression2 = sExpression;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Call.class, ExpressionList.class, MapExpression.class}, (Object)sExpression2, n)) {
                case 0: {
                    Call call = (Call)sExpression2;
                    if (!(substitute instanceof Call)) {
                        n = 1;
                        continue block5;
                    }
                    Call substituteCall = (Call)substitute;
                    if (!this.matchAndCollect(call.getSubject(), substituteCall.getSubject(), collectedArgs)) {
                        return false;
                    }
                    if (this.greedyMatchAndCollect(call.getArguments(), substituteCall.getArguments(), collectedArgs)) break block5;
                    return false;
                }
                case 1: {
                    ExpressionList list = (ExpressionList)sExpression2;
                    if (!(substitute instanceof ExpressionList)) {
                        n = 2;
                        continue block5;
                    }
                    ExpressionList substituteList = (ExpressionList)substitute;
                    if (this.greedyMatchAndCollect(list.getExpressions(), substituteList.getExpressions(), collectedArgs)) break block5;
                    return false;
                }
                case 2: {
                    MapExpression map = (MapExpression)sExpression2;
                    if (!(substitute instanceof MapExpression)) {
                        n = 3;
                        continue block5;
                    }
                    MapExpression substituteMap = (MapExpression)substitute;
                    Set<Map.Entry<SExpression, SExpression>> substituteSet = substituteMap.getExpressionMap().entrySet();
                    for (Map.Entry<SExpression, SExpression> entry : map.getExpressionMap().entrySet()) {
                        Optional<Object> substituteValue = Optional.empty();
                        for (Map.Entry<SExpression, SExpression> substituteEntry : substituteSet) {
                            if (!this.matchAndCollect(entry.getKey(), substituteEntry.getKey(), collectedArgs)) continue;
                            substituteValue = Optional.of(substituteEntry.getValue());
                        }
                        if (substituteValue.isEmpty()) {
                            return false;
                        }
                        if (this.matchAndCollect(entry.getValue(), (SExpression)substituteValue.get(), collectedArgs)) continue;
                        return false;
                    }
                    break block5;
                }
            }
            break;
        }
        return true;
    }

    private boolean confirmCollectedArguments(Map<String, List<SExpression>> collectedArgs) {
        for (String argName : this.arguments) {
            if (!collectedArgs.containsKey(argName)) {
                return false;
            }
            List<SExpression> argList = collectedArgs.get(argName);
            if (argList.stream().distinct().count() == 1L) continue;
            return false;
        }
        return !this.greedy || collectedArgs.containsKey("...");
    }

    private SExpression buildMacroCall(Map<String, List<SExpression>> collectedArgs) {
        MacroCallBuilder builder = MacroCallBuilder.builder(this.name);
        for (String argName : this.arguments) {
            builder.add(collectedArgs.get(argName).getFirst());
        }
        if (this.greedy) {
            collectedArgs.get("...").forEach(builder::add);
        }
        return builder.build();
    }

    public Optional<SExpression> matchAndCollect(SExpression expression) {
        HashMap<String, List<SExpression>> collectedArgs = new HashMap<String, List<SExpression>>();
        if (!this.matchAndCollect(expression, this.substitute, collectedArgs)) {
            return Optional.empty();
        }
        if (!this.confirmCollectedArguments(collectedArgs)) {
            return Optional.empty();
        }
        return Optional.of(this.buildMacroCall(collectedArgs));
    }

    public long treeSize() {
        return (long)this.arguments.size() + this.substitute.treeSize() + 3L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Macro)) {
            return false;
        }
        Macro macro = (Macro)o;
        return this.greedy == macro.greedy && Objects.equals(this.name, macro.name) && Objects.equals(this.arguments, macro.arguments) && Objects.equals(this.substitute, macro.substitute);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.arguments, this.greedy, this.substitute);
    }

    @Override
    public String toCode(int indent, int tabSize, boolean inline) {
        return LispUtils.addIndent(indent, inline) + "(#def " + this.name + " (" + String.join((CharSequence)" ", this.arguments) + (String)(this.greedy ? (this.arguments.isEmpty() ? "" : " ") + "..." : "") + ") \n" + this.substitute.toCode(indent + tabSize, tabSize, inline) + ")";
    }
}

