/*
 * Decompiled with CFR 0.152.
 */
package com.thejebforge.trickster_lisp.transpiler.ast;

import com.thejebforge.trickster_lisp.transpiler.LispUtils;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpressionType;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.List;
import java.util.Objects;

public class MacroCall
extends SExpression {
    public static final StructEndec<MacroCall> ENDEC = StructEndecBuilder.of((StructField)StructEndec.STRING.fieldOf("name", MacroCall::getMacroName), (StructField)SExpression.ENDEC.listOf().fieldOf("args", MacroCall::getArguments), MacroCall::new);
    private String macroName;
    private List<SExpression> arguments;

    public MacroCall(String macroName, List<SExpression> arguments) {
        this.macroName = macroName;
        this.arguments = arguments;
    }

    public String getMacroName() {
        return this.macroName;
    }

    public void setMacroName(String macroName) {
        this.macroName = macroName;
    }

    public List<SExpression> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<SExpression> arguments) {
        this.arguments = arguments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MacroCall)) {
            return false;
        }
        MacroCall call = (MacroCall)o;
        return Objects.equals(this.macroName, call.macroName) && Objects.equals(this.arguments, call.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.macroName, this.arguments);
    }

    public String toString() {
        return "Call{\nmacroName='" + this.macroName + "', \narguments=" + String.valueOf(this.arguments) + "\n}";
    }

    @Override
    public SExpressionType<?> type() {
        return SExpressionType.MACRO_CALL;
    }

    @Override
    public SExpression deepCopy() {
        return new MacroCall(this.macroName, this.arguments.stream().map(SExpression::deepCopy).toList());
    }

    @Override
    public boolean shallowEquals(SExpression other) {
        return other instanceof MacroCall;
    }

    @Override
    public String toCode(int indent, int tabSize, boolean inline) {
        return LispUtils.toCallCode(indent, tabSize, inline, this.macroName + "!", this.arguments);
    }
}

