/*
 * Decompiled with CFR 0.152.
 */
package com.thejebforge.trickster_lisp.transpiler.ast;

import com.thejebforge.trickster_lisp.transpiler.LispUtils;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpressionType;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class MapExpression
extends SExpression {
    public static final StructEndec<MapExpression> ENDEC = StructEndecBuilder.of((StructField)Endec.map(SExpression.ENDEC, SExpression.ENDEC).fieldOf("map", MapExpression::getExpressionMap), MapExpression::new);
    private HashMap<SExpression, SExpression> expressionMap;

    public MapExpression(Map<SExpression, SExpression> expressionMap) {
        this.expressionMap = new HashMap<SExpression, SExpression>(expressionMap);
    }

    public HashMap<SExpression, SExpression> getExpressionMap() {
        return this.expressionMap;
    }

    public void setExpressionMap(HashMap<SExpression, SExpression> expressionMap) {
        this.expressionMap = expressionMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapExpression)) {
            return false;
        }
        MapExpression that = (MapExpression)o;
        return Objects.equals(this.expressionMap, that.expressionMap);
    }

    public int hashCode() {
        return Objects.hashCode(this.expressionMap);
    }

    @Override
    public SExpressionType<?> type() {
        return SExpressionType.MAP;
    }

    @Override
    public SExpression deepCopy() {
        HashMap<SExpression, SExpression> newMap = new HashMap<SExpression, SExpression>();
        this.expressionMap.forEach((k, v) -> newMap.put(k.deepCopy(), v.deepCopy()));
        return new MapExpression(newMap);
    }

    @Override
    public boolean shallowEquals(SExpression other) {
        return other instanceof MapExpression;
    }

    @Override
    public String toCode(int indent, int tabSize, boolean inline) {
        if (this.expressionMap.isEmpty()) {
            return LispUtils.addIndent(indent, inline) + "{}";
        }
        return LispUtils.addIndent(indent, inline) + "{" + String.valueOf(this.expressionMap.size() == 1 ? "" : Character.valueOf('\n')) + this.expressionMap.entrySet().stream().map(e -> ((SExpression)e.getKey()).toCode(indent + tabSize, tabSize, this.expressionMap.size() == 1) + " : " + ((SExpression)e.getValue()).toCode(indent + tabSize, tabSize, true)).collect(Collectors.joining(",\n")) + "}";
    }
}

