/*
 * Decompiled with CFR 0.152.
 */
package com.thejebforge.trickster_lisp.transpiler.ast;

import com.thejebforge.trickster_lisp.transpiler.ast.Call;
import com.thejebforge.trickster_lisp.transpiler.ast.Empty;
import com.thejebforge.trickster_lisp.transpiler.ast.ExpressionList;
import com.thejebforge.trickster_lisp.transpiler.ast.Macro;
import com.thejebforge.trickster_lisp.transpiler.ast.MacroCall;
import com.thejebforge.trickster_lisp.transpiler.ast.MapExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.PreProcessor;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpression;
import io.vavr.Tuple2;
import java.lang.runtime.SwitchBootstraps;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public record Root(List<PreProcessor> preProcessors, List<SExpression> expressions) {
    public Root(List<Macro> macros) {
        this(new ArrayList<PreProcessor>(List.of((PreProcessor[])macros.stream().map(m -> m).toArray(PreProcessor[]::new))), new ArrayList<SExpression>());
    }

    public long treeSize() {
        return this.expressions().stream().mapToLong(SExpression::treeSize).sum();
    }

    public Root simplifyRoot() {
        Call call;
        SExpression sExpression;
        if (this.expressions.size() == 1 && (sExpression = this.expressions.getFirst()) instanceof Call && (call = (Call)sExpression).getSubject() instanceof Empty) {
            return new Root(this.preProcessors, call.getArguments());
        }
        return this;
    }

    private Map<String, Macro> collectMacroMap(List<PreProcessor> preProcessors) {
        HashMap<String, Macro> map = new HashMap<String, Macro>();
        preProcessors.stream().filter(p -> p instanceof Macro).map(p -> (Macro)p).forEach(m -> map.put(m.getName(), (Macro)m));
        return map;
    }

    private SExpression traverseAndApply(SExpression expr, Function<SExpression, SExpression> func) {
        if ((expr = func.apply(expr)) instanceof Call) {
            Call call = (Call)expr;
            return new Call(this.traverseAndApply(call.getSubject(), func), call.getArguments().stream().map(a -> this.traverseAndApply((SExpression)a, func)).toList());
        }
        if (expr instanceof ExpressionList) {
            ExpressionList list = (ExpressionList)expr;
            return new ExpressionList(list.getExpressions().stream().map(a -> this.traverseAndApply((SExpression)a, func)).toList());
        }
        if (expr instanceof MapExpression) {
            MapExpression map = (MapExpression)expr;
            HashMap<SExpression, SExpression> newMap = new HashMap<SExpression, SExpression>();
            map.getExpressionMap().forEach((k, v) -> newMap.put(this.traverseAndApply((SExpression)k, func), this.traverseAndApply((SExpression)v, func)));
            return new MapExpression(newMap);
        }
        return expr;
    }

    private SExpression applyMacros(SExpression expr, Map<String, Macro> macros) {
        MacroCall call;
        if (expr instanceof MacroCall && macros.containsKey((call = (MacroCall)expr).getMacroName())) {
            return macros.get(call.getMacroName()).apply(expr, call.getArguments().stream().map(e -> this.traverseAndApply((SExpression)e, ie -> this.applyMacros((SExpression)ie, macros))).toList());
        }
        return expr;
    }

    public Root runPreProcessors(List<PreProcessor> preProcessors) {
        Map<String, Macro> macros = this.collectMacroMap(preProcessors);
        return new Root(this.preProcessors, this.expressions.stream().map(rootExpr -> this.traverseAndApply((SExpression)rootExpr, expr -> this.applyMacros((SExpression)expr, macros))).toList());
    }

    public Root runPreProcessors() {
        return this.runPreProcessors(this.preProcessors);
    }

    public Root reverseMacros(List<Macro> macros) {
        return new Root(this.preProcessors, this.expressions.stream().map(e -> this.reverseMacros((SExpression)e, macros)).collect(Collectors.toCollection(ArrayList::new)));
    }

    public Root reverseMacros() {
        return this.reverseMacros(this.retrieveMacros());
    }

    private SExpression reverseMacros(SExpression expr, List<Macro> macros) {
        SExpression currentExpr = expr;
        Optional<Tuple2> candidate = macros.stream().map(m -> new Tuple2(m, m.matchAndCollect(currentExpr))).filter(t -> ((Optional)t._2()).isPresent()).max(Comparator.comparingLong(a -> ((Macro)a._1()).treeSize()));
        SExpression sExpression = expr = candidate.map(t -> (SExpression)((Optional)t._2()).get()).orElse(expr);
        Objects.requireNonNull(sExpression);
        SExpression sExpression2 = sExpression;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Call.class, MacroCall.class, ExpressionList.class, MapExpression.class}, (Object)sExpression2, n)) {
            case 0: {
                Call call = (Call)sExpression2;
                call.setSubject(this.reverseMacros(call.getSubject(), macros));
                call.setArguments(call.getArguments().stream().map(e -> this.reverseMacros((SExpression)e, macros)).collect(Collectors.toCollection(ArrayList::new)));
                break;
            }
            case 1: {
                MacroCall macroCall = (MacroCall)sExpression2;
                macroCall.setArguments(macroCall.getArguments().stream().map(e -> this.reverseMacros((SExpression)e, macros)).collect(Collectors.toCollection(ArrayList::new)));
                break;
            }
            case 2: {
                ExpressionList list = (ExpressionList)sExpression2;
                list.setExpressions(list.getExpressions().stream().map(e -> this.reverseMacros((SExpression)e, macros)).collect(Collectors.toCollection(ArrayList::new)));
                break;
            }
            case 3: {
                MapExpression map = (MapExpression)sExpression2;
                HashMap<SExpression, SExpression> newMap = new HashMap<SExpression, SExpression>();
                map.getExpressionMap().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<SExpression, SExpression>(this.reverseMacros((SExpression)entry.getKey(), macros), this.reverseMacros((SExpression)entry.getValue(), macros))).forEach(e -> newMap.put((SExpression)e.getKey(), (SExpression)e.getValue()));
                map.setExpressionMap(newMap);
                break;
            }
        }
        return expr;
    }

    public Root prependMacros(Collection<Macro> macros) {
        this.preProcessors.addAll(0, macros);
        return this;
    }

    public Root appendMacros(Collection<Macro> macros) {
        this.preProcessors.addAll(macros);
        return this;
    }

    public List<Macro> retrieveMacros() {
        return this.preProcessors.stream().filter(p -> p instanceof Macro).map(Macro.class::cast).toList();
    }

    @Override
    public String toString() {
        return "Root{\npreProcessors=" + String.valueOf(this.preProcessors) + ", \nexpressions=" + String.valueOf(this.expressions) + "\n}";
    }

    public String toCode() {
        return this.toCode(4);
    }

    public String toCode(int tabSize) {
        return this.preProcessors.stream().map(p -> p.toCode(0, tabSize, false)).collect(Collectors.joining("\n")) + (!this.preProcessors.isEmpty() && !this.expressions.isEmpty() ? "\n\n" : "") + this.expressions.stream().map(e -> e.toCode(0, tabSize, false)).collect(Collectors.joining("\n"));
    }
}

