/*
 * Decompiled with CFR 0.152.
 */
package com.thejebforge.trickster_lisp.transpiler.ast;

import com.thejebforge.trickster_lisp.transpiler.LispUtils;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpressionType;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.Objects;

public class StringExpression
extends SExpression {
    public static final StructEndec<StringExpression> ENDEC = StructEndecBuilder.of((StructField)StructEndec.STRING.fieldOf("v", StringExpression::getValue), StringExpression::new);
    private String value;

    public StringExpression(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringExpression)) {
            return false;
        }
        StringExpression that = (StringExpression)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return "StringExpression{\nvalue='" + this.value + "'\n}";
    }

    @Override
    public SExpressionType<?> type() {
        return SExpressionType.STRING;
    }

    @Override
    public SExpression deepCopy() {
        return new StringExpression(this.value);
    }

    @Override
    public boolean shallowEquals(SExpression other) {
        return this.equals(other);
    }

    @Override
    public String toCode(int indent, int tabSize, boolean inline) {
        return LispUtils.addIndent(indent, inline) + "\"" + this.value + "\"";
    }
}

