/*
 * Decompiled with CFR 0.152.
 */
package com.thejebforge.trickster_lisp.transpiler.ast.builder;

import com.thejebforge.trickster_lisp.transpiler.ast.BooleanValue;
import com.thejebforge.trickster_lisp.transpiler.ast.Call;
import com.thejebforge.trickster_lisp.transpiler.ast.DoubleValue;
import com.thejebforge.trickster_lisp.transpiler.ast.Empty;
import com.thejebforge.trickster_lisp.transpiler.ast.Identifier;
import com.thejebforge.trickster_lisp.transpiler.ast.IntegerValue;
import com.thejebforge.trickster_lisp.transpiler.ast.Operator;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.StringExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.ExpressionBuilder;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.ListBuilder;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.MacroCallBuilder;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.MapBuilder;
import java.util.ArrayList;
import java.util.function.Function;

public class CallBuilder
implements ExpressionBuilder<CallBuilder, Call> {
    private final Call call;

    private CallBuilder(Call call) {
        this.call = call;
    }

    public static CallBuilder builder(SExpression subject) {
        return new CallBuilder(new Call(subject, new ArrayList<SExpression>()));
    }

    public static CallBuilder builder(String subject) {
        return new CallBuilder(new Call(new Identifier(subject), new ArrayList<SExpression>()));
    }

    public static CallBuilder builder(Double subject) {
        return new CallBuilder(new Call(new DoubleValue(subject), new ArrayList<SExpression>()));
    }

    public static CallBuilder builder(Integer subject) {
        return new CallBuilder(new Call(new DoubleValue(subject.intValue()), new ArrayList<SExpression>()));
    }

    public static CallBuilder builder(Boolean subject) {
        return new CallBuilder(new Call(new BooleanValue(subject), new ArrayList<SExpression>()));
    }

    public static CallBuilder builder() {
        return new CallBuilder(new Call(Empty.INSTANCE, new ArrayList<SExpression>()));
    }

    @Override
    public CallBuilder add(SExpression expression) {
        this.call.getArguments().add(expression);
        return this;
    }

    @Override
    public CallBuilder addIdentifier(String name) {
        this.call.getArguments().add(new Identifier(name));
        return this;
    }

    @Override
    public CallBuilder addOperator(String operator) {
        this.call.getArguments().add(new Operator(operator));
        return this;
    }

    @Override
    public CallBuilder addNumber(Double number) {
        this.call.getArguments().add(new DoubleValue(number));
        return this;
    }

    @Override
    public CallBuilder addNumber(Integer number) {
        this.call.getArguments().add(new IntegerValue(number));
        return this;
    }

    @Override
    public CallBuilder addBoolean(Boolean value) {
        this.call.getArguments().add(new BooleanValue(value));
        return this;
    }

    @Override
    public CallBuilder addString(String value) {
        this.call.getArguments().add(new StringExpression(value));
        return this;
    }

    @Override
    public CallBuilder addCall(SExpression subject, Function<CallBuilder, CallBuilder> builder) {
        this.call.getArguments().add(builder.apply(CallBuilder.builder(subject)).build());
        return this;
    }

    @Override
    public CallBuilder addMacroCall(String name, Function<MacroCallBuilder, MacroCallBuilder> builder) {
        this.call.getArguments().add(builder.apply(MacroCallBuilder.builder(name)).build());
        return this;
    }

    @Override
    public CallBuilder addList(Function<ListBuilder, ListBuilder> builder) {
        this.call.getArguments().add(builder.apply(ListBuilder.builder()).build());
        return this;
    }

    @Override
    public CallBuilder addMap(Function<MapBuilder, MapBuilder> builder) {
        this.call.getArguments().add(builder.apply(MapBuilder.builder()).build());
        return this;
    }

    @Override
    public Call build() {
        return this.call;
    }
}

