/*
 * Decompiled with CFR 0.152.
 */
package com.thejebforge.trickster_lisp.transpiler.ast.builder;

import com.thejebforge.trickster_lisp.transpiler.ast.BooleanValue;
import com.thejebforge.trickster_lisp.transpiler.ast.DoubleValue;
import com.thejebforge.trickster_lisp.transpiler.ast.Empty;
import com.thejebforge.trickster_lisp.transpiler.ast.Identifier;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.CallBuilder;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.ListBuilder;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.MacroCallBuilder;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.MapBuilder;
import java.util.function.Function;

public interface ExpressionBuilder<T, R> {
    public T add(SExpression var1);

    public T addIdentifier(String var1);

    public T addOperator(String var1);

    public T addNumber(Double var1);

    public T addNumber(Integer var1);

    public T addBoolean(Boolean var1);

    public T addString(String var1);

    public T addCall(SExpression var1, Function<CallBuilder, CallBuilder> var2);

    default public T addCall(String subject, Function<CallBuilder, CallBuilder> builder) {
        return this.addCall(new Identifier(subject), builder);
    }

    default public T addCall(Double subject, Function<CallBuilder, CallBuilder> builder) {
        return this.addCall(new DoubleValue(subject), builder);
    }

    default public T addCall(Integer subject, Function<CallBuilder, CallBuilder> builder) {
        return this.addCall(new DoubleValue(subject.intValue()), builder);
    }

    default public T addCall(Boolean subject, Function<CallBuilder, CallBuilder> builder) {
        return this.addCall(new BooleanValue(subject), builder);
    }

    default public T addCall(Function<CallBuilder, CallBuilder> builder) {
        return this.addCall(Empty.INSTANCE, builder);
    }

    public T addMacroCall(String var1, Function<MacroCallBuilder, MacroCallBuilder> var2);

    public T addList(Function<ListBuilder, ListBuilder> var1);

    public T addMap(Function<MapBuilder, MapBuilder> var1);

    public R build();
}

