/*
 * Decompiled with CFR 0.152.
 */
package com.thejebforge.trickster_lisp.transpiler.ast.builder;

import com.thejebforge.trickster_lisp.transpiler.ast.BooleanValue;
import com.thejebforge.trickster_lisp.transpiler.ast.DoubleValue;
import com.thejebforge.trickster_lisp.transpiler.ast.ExpressionList;
import com.thejebforge.trickster_lisp.transpiler.ast.Identifier;
import com.thejebforge.trickster_lisp.transpiler.ast.IntegerValue;
import com.thejebforge.trickster_lisp.transpiler.ast.Operator;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.StringExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.CallBuilder;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.ExpressionBuilder;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.MacroCallBuilder;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.MapBuilder;
import java.util.ArrayList;
import java.util.function.Function;

public class ListBuilder
implements ExpressionBuilder<ListBuilder, ExpressionList> {
    private final ExpressionList list;

    private ListBuilder(ExpressionList list) {
        this.list = list;
    }

    public static ListBuilder builder() {
        return new ListBuilder(new ExpressionList(new ArrayList<SExpression>()));
    }

    @Override
    public ListBuilder add(SExpression expression) {
        this.list.getExpressions().add(expression);
        return this;
    }

    @Override
    public ListBuilder addIdentifier(String name) {
        this.list.getExpressions().add(new Identifier(name));
        return this;
    }

    @Override
    public ListBuilder addOperator(String operator) {
        this.list.getExpressions().add(new Operator(operator));
        return this;
    }

    @Override
    public ListBuilder addNumber(Double number) {
        this.list.getExpressions().add(new DoubleValue(number));
        return this;
    }

    @Override
    public ListBuilder addNumber(Integer number) {
        this.list.getExpressions().add(new IntegerValue(number));
        return this;
    }

    @Override
    public ListBuilder addBoolean(Boolean value) {
        this.list.getExpressions().add(new BooleanValue(value));
        return this;
    }

    @Override
    public ListBuilder addString(String value) {
        this.list.getExpressions().add(new StringExpression(value));
        return this;
    }

    @Override
    public ListBuilder addCall(SExpression subject, Function<CallBuilder, CallBuilder> builder) {
        this.list.getExpressions().add(builder.apply(CallBuilder.builder(subject)).build());
        return this;
    }

    @Override
    public ListBuilder addMacroCall(String name, Function<MacroCallBuilder, MacroCallBuilder> builder) {
        this.list.getExpressions().add(builder.apply(MacroCallBuilder.builder(name)).build());
        return this;
    }

    @Override
    public ListBuilder addList(Function<ListBuilder, ListBuilder> builder) {
        this.list.getExpressions().add(builder.apply(ListBuilder.builder()).build());
        return this;
    }

    @Override
    public ListBuilder addMap(Function<MapBuilder, MapBuilder> builder) {
        this.list.getExpressions().add(builder.apply(MapBuilder.builder()).build());
        return this;
    }

    @Override
    public ExpressionList build() {
        return this.list;
    }
}

