/*
 * Decompiled with CFR 0.152.
 */
package com.thejebforge.trickster_lisp.transpiler.ast.builder;

import com.thejebforge.trickster_lisp.transpiler.ast.BooleanValue;
import com.thejebforge.trickster_lisp.transpiler.ast.DoubleValue;
import com.thejebforge.trickster_lisp.transpiler.ast.Identifier;
import com.thejebforge.trickster_lisp.transpiler.ast.IntegerValue;
import com.thejebforge.trickster_lisp.transpiler.ast.MacroCall;
import com.thejebforge.trickster_lisp.transpiler.ast.Operator;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.StringExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.CallBuilder;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.ExpressionBuilder;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.ListBuilder;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.MapBuilder;
import java.util.ArrayList;
import java.util.function.Function;

public class MacroCallBuilder
implements ExpressionBuilder<MacroCallBuilder, MacroCall> {
    private final MacroCall call;

    private MacroCallBuilder(MacroCall call) {
        this.call = call;
    }

    public static MacroCallBuilder builder(String name) {
        return new MacroCallBuilder(new MacroCall(name, new ArrayList<SExpression>()));
    }

    @Override
    public MacroCallBuilder add(SExpression expression) {
        this.call.getArguments().add(expression);
        return this;
    }

    @Override
    public MacroCallBuilder addIdentifier(String name) {
        this.call.getArguments().add(new Identifier(name));
        return this;
    }

    @Override
    public MacroCallBuilder addOperator(String operator) {
        this.call.getArguments().add(new Operator(operator));
        return this;
    }

    @Override
    public MacroCallBuilder addNumber(Double number) {
        this.call.getArguments().add(new DoubleValue(number));
        return this;
    }

    @Override
    public MacroCallBuilder addNumber(Integer number) {
        this.call.getArguments().add(new IntegerValue(number));
        return this;
    }

    @Override
    public MacroCallBuilder addBoolean(Boolean value) {
        this.call.getArguments().add(new BooleanValue(value));
        return this;
    }

    @Override
    public MacroCallBuilder addString(String value) {
        this.call.getArguments().add(new StringExpression(value));
        return this;
    }

    @Override
    public MacroCallBuilder addCall(SExpression subject, Function<CallBuilder, CallBuilder> builder) {
        this.call.getArguments().add(builder.apply(CallBuilder.builder(subject)).build());
        return this;
    }

    @Override
    public MacroCallBuilder addMacroCall(String name, Function<MacroCallBuilder, MacroCallBuilder> builder) {
        this.call.getArguments().add(builder.apply(MacroCallBuilder.builder(name)).build());
        return this;
    }

    @Override
    public MacroCallBuilder addList(Function<ListBuilder, ListBuilder> builder) {
        this.call.getArguments().add(builder.apply(ListBuilder.builder()).build());
        return this;
    }

    @Override
    public MacroCallBuilder addMap(Function<MapBuilder, MapBuilder> builder) {
        this.call.getArguments().add(builder.apply(MapBuilder.builder()).build());
        return this;
    }

    @Override
    public MacroCall build() {
        return this.call;
    }
}

