/*
 * Decompiled with CFR 0.152.
 */
package com.thejebforge.trickster_lisp.transpiler.ast.builder;

import com.thejebforge.trickster_lisp.transpiler.ast.BooleanValue;
import com.thejebforge.trickster_lisp.transpiler.ast.DoubleValue;
import com.thejebforge.trickster_lisp.transpiler.ast.Identifier;
import com.thejebforge.trickster_lisp.transpiler.ast.IntegerValue;
import com.thejebforge.trickster_lisp.transpiler.ast.Operator;
import com.thejebforge.trickster_lisp.transpiler.ast.PreProcessor;
import com.thejebforge.trickster_lisp.transpiler.ast.Root;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.StringExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.CallBuilder;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.ExpressionBuilder;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.ListBuilder;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.MacroCallBuilder;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.MapBuilder;
import java.util.ArrayList;
import java.util.function.Function;

public class RootBuilder
implements ExpressionBuilder<RootBuilder, Root> {
    private final Root root = new Root(new ArrayList<PreProcessor>(), new ArrayList<SExpression>());

    private RootBuilder() {
    }

    public static RootBuilder builder() {
        return new RootBuilder();
    }

    public RootBuilder add(PreProcessor preProcessor) {
        this.root.preProcessors().add(preProcessor);
        return this;
    }

    @Override
    public RootBuilder add(SExpression expression) {
        this.root.expressions().add(expression);
        return this;
    }

    @Override
    public RootBuilder addIdentifier(String name) {
        this.root.expressions().add(new Identifier(name));
        return this;
    }

    @Override
    public RootBuilder addOperator(String operator) {
        this.root.expressions().add(new Operator(operator));
        return this;
    }

    @Override
    public RootBuilder addNumber(Double number) {
        this.root.expressions().add(new DoubleValue(number));
        return this;
    }

    @Override
    public RootBuilder addNumber(Integer number) {
        this.root.expressions().add(new IntegerValue(number));
        return this;
    }

    @Override
    public RootBuilder addBoolean(Boolean value) {
        this.root.expressions().add(new BooleanValue(value));
        return this;
    }

    @Override
    public RootBuilder addString(String value) {
        this.root.expressions().add(new StringExpression(value));
        return this;
    }

    @Override
    public RootBuilder addCall(SExpression subject, Function<CallBuilder, CallBuilder> builder) {
        this.root.expressions().add(builder.apply(CallBuilder.builder(subject)).build());
        return this;
    }

    @Override
    public RootBuilder addMacroCall(String name, Function<MacroCallBuilder, MacroCallBuilder> builder) {
        this.root.expressions().add(builder.apply(MacroCallBuilder.builder(name)).build());
        return this;
    }

    @Override
    public RootBuilder addList(Function<ListBuilder, ListBuilder> builder) {
        this.root.expressions().add(builder.apply(ListBuilder.builder()).build());
        return this;
    }

    @Override
    public RootBuilder addMap(Function<MapBuilder, MapBuilder> builder) {
        this.root.expressions().add(builder.apply(MapBuilder.builder()).build());
        return this;
    }

    @Override
    public Root build() {
        return this.root;
    }
}

