/*
 * Decompiled with CFR 0.152.
 */
package com.thejebforge.trickster_lisp.transpiler.util;

import com.thejebforge.trickster_lisp.transpiler.ast.Call;
import com.thejebforge.trickster_lisp.transpiler.ast.DoubleValue;
import com.thejebforge.trickster_lisp.transpiler.ast.Identifier;
import com.thejebforge.trickster_lisp.transpiler.ast.IntegerValue;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.StringExpression;

public abstract class CallUtils {
    public static boolean matchCall(Call call, String id) {
        Identifier identifier;
        SExpression sExpression = call.getSubject();
        return sExpression instanceof Identifier && (identifier = (Identifier)sExpression).getName().equals(id);
    }

    public static void expectArgumentCount(Call call, int argumentCount) {
        if (call.getArguments().size() < argumentCount) {
            throw CallUtils.getConversionError(call, String.format("Expected at least %d arguments", argumentCount));
        }
    }

    public static String getStringArgument(Call call, int index) {
        if (call.getArguments().size() < index + 1) {
            throw CallUtils.getConversionError(call, String.format("Expected at least %d arguments", index + 1));
        }
        SExpression sExpression = call.getArguments().get(index);
        if (sExpression instanceof StringExpression) {
            StringExpression string = (StringExpression)sExpression;
            return string.getValue();
        }
        throw CallUtils.getConversionError(call, String.format("Expected string at %d argument", index));
    }

    public static Integer getIntegerArgument(Call call, int index) {
        if (call.getArguments().size() < index + 1) {
            throw CallUtils.getConversionError(call, String.format("Expected at least %d arguments", index + 1));
        }
        SExpression sExpression = call.getArguments().get(index);
        if (sExpression instanceof IntegerValue) {
            IntegerValue integerValue = (IntegerValue)sExpression;
            return integerValue.getNumber();
        }
        sExpression = call.getArguments().get(index);
        if (sExpression instanceof DoubleValue) {
            DoubleValue doubleValue = (DoubleValue)sExpression;
            return (int)doubleValue.getNumber();
        }
        throw CallUtils.getConversionError(call, String.format("Expected integer at %d argument", index));
    }

    public static Double getDoubleArgument(Call call, int index) {
        if (call.getArguments().size() < index + 1) {
            throw CallUtils.getConversionError(call, String.format("Expected at least %d arguments", index + 1));
        }
        SExpression sExpression = call.getArguments().get(index);
        if (sExpression instanceof IntegerValue) {
            IntegerValue integerValue = (IntegerValue)sExpression;
            return integerValue.getNumber();
        }
        sExpression = call.getArguments().get(index);
        if (sExpression instanceof DoubleValue) {
            DoubleValue doubleValue = (DoubleValue)sExpression;
            return doubleValue.getNumber();
        }
        throw CallUtils.getConversionError(call, String.format("Expected float at %d argument", index));
    }

    public static Call getCallArgument(Call call, int index) {
        if (call.getArguments().size() < index + 1) {
            throw CallUtils.getConversionError(call, String.format("Expected at least %d arguments", index + 1));
        }
        SExpression sExpression = call.getArguments().get(index);
        if (sExpression instanceof Call) {
            Call callArgument = (Call)sExpression;
            return callArgument;
        }
        throw CallUtils.getConversionError(call, String.format("Expected call at %d argument", index));
    }

    public static Call getNamedCallArgument(Call call, int index, String name) {
        if (call.getArguments().size() < index + 1) {
            throw CallUtils.getConversionError(call, String.format("Expected at least %d arguments", index + 1));
        }
        SExpression sExpression = call.getArguments().get(index);
        if (sExpression instanceof Call) {
            Call callArgument = (Call)sExpression;
            if (!CallUtils.matchCall(callArgument, name)) {
                throw CallUtils.getConversionError(call, String.format("Expected '%s' call at %d argument", name, index));
            }
            return callArgument;
        }
        throw CallUtils.getConversionError(call, String.format("Expected call at %d argument", index));
    }

    public static ConversionError getConversionError(SExpression expression, String reason) {
        return new ConversionError(String.format("Couldn't convert expression to spell: %s\n%s", reason, expression.toCode(0)));
    }

    public static class ConversionError
    extends RuntimeException {
        public ConversionError(String message) {
            super(message);
        }
    }
}

