/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.item.armor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.errorcraft.itematic.entity.EquipmentSlotUtil;
import net.errorcraft.itematic.mixin.item.ArmorItemAccessor;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9285;

public record ArmorMaterial(class_2960 assetId, Map<class_1738.class_8051, Integer> defense, double toughness, double knockbackResistance) {
    public static final Codec<ArmorMaterial> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("asset_id").forGetter(ArmorMaterial::assetId), (App)Codec.simpleMap((Codec)class_1738.class_8051.field_48839, (Codec)Codec.INT, (Keyable)class_3542.method_28142((class_3542[])class_1738.class_8051.values())).fieldOf("defense").forGetter(ArmorMaterial::defense), (App)Codec.DOUBLE.fieldOf("toughness").forGetter(ArmorMaterial::toughness), (App)Codec.DOUBLE.fieldOf("knockback_resistance").forGetter(ArmorMaterial::knockbackResistance)).apply((Applicative)instance, ArmorMaterial::new));
    private static final Map<class_1304, UUID> EQUIPMENT_SLOT_ATTRIBUTE_UUIDS = ArmorItemAccessor.attributeModifiers().entrySet().stream().collect(Collectors.toMap(entry -> ((class_1738.class_8051)entry.getKey()).method_48399(), Map.Entry::getValue));

    public int defense(class_1304 slot) {
        class_1738.class_8051 type = EquipmentSlotUtil.armorType(slot);
        if (type == null) {
            return 0;
        }
        return this.defense.getOrDefault(type, 0);
    }

    public class_2960 textureId(boolean secondLayer) {
        if (secondLayer) {
            this.assetId.method_45134(path -> "models/armor/" + path + "_layer_2");
        }
        return this.assetId.method_45134(path -> "models/armor/" + path + "_layer_1");
    }

    public void addAttributes(class_9285.class_9286 builder, class_1304 slot) {
        UUID uuid = EQUIPMENT_SLOT_ATTRIBUTE_UUIDS.get(slot);
        int defense = this.defense(slot);
        if (defense > 0) {
            builder.method_57487(class_5134.field_23724, new class_1322(uuid, "Armor modifier", (double)defense, class_1322.class_1323.field_6328), class_9274.method_59524((class_1304)slot));
        }
        builder.method_57487(class_5134.field_23725, new class_1322(uuid, "Armor toughness", this.toughness, class_1322.class_1323.field_6328), class_9274.method_59524((class_1304)slot));
        if (this.knockbackResistance > 0.0) {
            builder.method_57487(class_5134.field_23718, new class_1322(uuid, "Armor knockback resistance", this.knockbackResistance, class_1322.class_1323.field_6328), class_9274.method_59524((class_1304)slot));
        }
    }

    public static ArmorMaterial from(class_2960 assetId, class_6880<class_1741> material) {
        return new ArmorMaterial(assetId, ((class_1741)material.comp_349()).comp_2298(), ((class_1741)material.comp_349()).comp_2303(), ((class_1741)material.comp_349()).comp_2304());
    }
}

