/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.item.component.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.errorcraft.itematic.item.ItemKeys;
import net.errorcraft.itematic.item.ItemStackConsumer;
import net.errorcraft.itematic.item.component.ItemComponent;
import net.errorcraft.itematic.item.component.ItemComponentType;
import net.errorcraft.itematic.item.component.ItemComponentTypes;
import net.errorcraft.itematic.mixin.item.CrossbowItemAccessor;
import net.errorcraft.itematic.world.action.context.ActionContext;
import net.errorcraft.itematic.world.action.context.parameter.ActionContextParameter;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9278;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public record ShooterItemComponent(class_6862<class_1792> heldAmmunition, class_6862<class_1792> ammunition, int range, Optional<Chargeable> chargeable) implements ItemComponent<ShooterItemComponent>
{
    public static final Codec<ShooterItemComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6862.method_40090((class_5321)class_7924.field_41197).fieldOf("held_ammunition").forGetter(ShooterItemComponent::heldAmmunition), (App)class_6862.method_40090((class_5321)class_7924.field_41197).fieldOf("ammunition").forGetter(ShooterItemComponent::ammunition), (App)class_5699.field_33442.fieldOf("range").forGetter(ShooterItemComponent::range), (App)Chargeable.CODEC.optionalFieldOf("chargeable").forGetter(ShooterItemComponent::chargeable)).apply((Applicative)instance, ShooterItemComponent::new));
    private static final float CHARGE_PROGRESS = CrossbowItemAccessor.chargeProgress();
    private static final float LOAD_PROGRESS = CrossbowItemAccessor.loadProgress();
    private static final int DEFAULT_CHARGE_TIME = CrossbowItemAccessor.defaultPullTime();
    private static final int EXTRA_USE_TIME = 3;
    private static final int CHARGE_TIME_PER_QUICK_CHARGE_LEVEL = 5;
    private static final class_1764 DUMMY = new class_1764(new class_1792.class_1793());

    public static ShooterItemComponent of(class_6862<class_1792> heldAmmunition, class_6862<class_1792> ammunition, int range) {
        return new ShooterItemComponent(heldAmmunition, ammunition, range, Optional.empty());
    }

    @SafeVarargs
    public static ShooterItemComponent of(class_6862<class_1792> heldAmmunition, class_6862<class_1792> ammunition, int range, class_6880<class_3414> defaultSound, class_6880<class_3414> ... levelSounds) {
        return new ShooterItemComponent(heldAmmunition, ammunition, range, Optional.of(Chargeable.of(QuickChargeSounds.of(defaultSound, levelSounds))));
    }

    @Override
    public ItemComponentType<ShooterItemComponent> type() {
        return ItemComponentTypes.SHOOTER;
    }

    @Override
    public Codec<ShooterItemComponent> codec() {
        return CODEC;
    }

    @Override
    public class_1269 use(class_1937 world, class_1657 user, class_1268 hand, class_1799 stack, ItemStackConsumer resultStackConsumer) {
        if (this.isCharged(stack)) {
            float chargedSpeed = ((class_9278)stack.method_57825(class_9334.field_49649, (Object)class_9278.field_49298)).itematic$getChargedSpeed();
            DUMMY.method_7777(world, (class_1309)user, hand, stack, chargedSpeed, 1.0f, null);
            return class_1269.field_21466;
        }
        if (!user.itematic$getAmmunition(this).method_7960()) {
            user.method_6019(hand);
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    @Override
    public void using(class_1799 stack, class_1937 world, class_1309 user, int usedTicks, int remainingUseTicks) {
        this.chargeable.ifPresent(chargeable -> this.tryLoad(stack, world, user, usedTicks, (Chargeable)chargeable));
    }

    @Override
    public void stopUsing(class_1799 stack, class_1937 world, class_1309 user, int usedTicks, int remainingUseTicks, ItemStackConsumer resultStackConsumer) {
        float pullProgress = this.getPullProgress(stack, usedTicks);
        if (this.isChargeable()) {
            this.charge(stack, world, user, pullProgress);
            return;
        }
        if (!(user instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)user;
        this.shoot(stack, world, player, pullProgress, resultStackConsumer);
    }

    @Override
    public void addComponents(class_9323.class_9324 builder) {
        if (this.isChargeable()) {
            builder.method_57840(class_9334.field_49649, (Object)class_9278.field_49298);
        }
    }

    public static int useDuration(class_1799 stack) {
        return ShooterItemComponent.getPullTime(stack) + 3;
    }

    public static int getPullTime(class_1799 stack) {
        int quickChargeLevel = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)stack);
        return DEFAULT_CHARGE_TIME - 5 * quickChargeLevel;
    }

    public void shootAll(class_1937 world, class_1309 shooter, class_1268 hand, class_1799 stack, float speed, float divergence, @Nullable class_1309 target) {
        DUMMY.method_7777(world, shooter, hand, stack, speed, divergence, target);
    }

    public boolean isHeldAmmunition(class_1799 stack) {
        return stack.method_31573(this.heldAmmunition);
    }

    public boolean isAmmunition(class_1799 stack) {
        return stack.method_31573(this.ammunition);
    }

    public float getPullProgress(class_1799 stack, int usedTicks) {
        if (this.isChargeable()) {
            float progress = (float)usedTicks / (float)ShooterItemComponent.getPullTime(stack);
            return Math.min(progress, 1.0f);
        }
        return class_1753.method_7722((int)usedTicks);
    }

    public boolean isChargeable() {
        return this.chargeable.isPresent();
    }

    public boolean isCharged(class_1799 stack) {
        return this.isChargeable() && !((class_9278)stack.method_57825(class_9334.field_49649, (Object)class_9278.field_49298)).method_57442();
    }

    private void tryLoad(class_1799 stack, class_1937 world, class_1309 user, int usedTicks, Chargeable chargeable) {
        if (world.method_8608()) {
            return;
        }
        int pullTime = ShooterItemComponent.getPullTime(stack);
        if (usedTicks >= pullTime) {
            return;
        }
        int quickChargeLevel = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)stack);
        if (usedTicks == ShooterItemComponent.getPullTimeAt(pullTime, CHARGE_PROGRESS)) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), (class_3414)chargeable.quickChargeSounds.get(quickChargeLevel).comp_349(), class_3419.field_15248, 0.5f, 1.0f);
            return;
        }
        if (usedTicks == ShooterItemComponent.getPullTimeAt(pullTime, LOAD_PROGRESS) && quickChargeLevel == 0) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14860, class_3419.field_15248, 0.5f, 1.0f);
        }
    }

    private void charge(class_1799 stack, class_1937 world, class_1309 user, float pullProgress) {
        if (pullProgress == 1.0f && !this.isCharged(stack) && CrossbowItemAccessor.loadProjectiles(user, stack)) {
            class_3419 soundCategory = user instanceof class_1657 ? class_3419.field_15248 : class_3419.field_15251;
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14626, soundCategory, 1.0f, 1.0f / (world.method_8409().method_43057() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private void shoot(class_1799 stack, class_1937 world, class_1657 player, float pullProgress, ItemStackConsumer resultStackConsumer) {
        boolean disallowPickup;
        if (pullProgress < 0.1f) {
            return;
        }
        class_1799 ammunition = player.itematic$getAmmunition(this);
        if (ammunition.method_7960()) {
            return;
        }
        boolean bl = disallowPickup = class_1890.method_8225((class_1887)class_1893.field_9125, (class_1799)stack) > 0 && ammunition.itematic$isOf(ItemKeys.ARROW);
        if (!world.method_8608()) {
            this.createProjectile(stack, ammunition, (class_3218)world, player, pullProgress, disallowPickup, resultStackConsumer);
        }
        world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14600, class_3419.field_15248, 1.0f, 1.0f / (world.method_8409().method_43057() * 0.4f + 1.2f) + pullProgress * 0.5f);
        if (player.method_31549().field_7477 || disallowPickup) {
            return;
        }
        ammunition.method_7934(1);
        if (ammunition.method_7960()) {
            player.method_31548().method_7378(ammunition);
        }
    }

    private void createProjectile(class_1799 stack, class_1799 ammunition, class_3218 world, class_1657 player, float pullProgress, boolean disallowPickup, ItemStackConsumer resultStackConsumer) {
        Optional<class_1297> optionalEntity = ammunition.itematic$getComponent(ItemComponentTypes.PROJECTILE).map(c -> c.createEntity((class_1937)world, (class_1297)player, ammunition, 0.0f, pullProgress * 3.0f));
        if (optionalEntity.isEmpty()) {
            return;
        }
        class_1297 entity = optionalEntity.get();
        if (entity instanceof class_1665) {
            class_1665 persistentProjectileEntity = (class_1665)entity;
            this.initProjectile(persistentProjectileEntity, stack, pullProgress);
            ActionContext context = ActionContext.builder(world, stack, resultStackConsumer, player.method_6058()).entityPosition(ActionContextParameter.THIS, (class_1297)player).build();
            stack.itematic$damage(1, context);
            if (disallowPickup) {
                persistentProjectileEntity.field_7572 = class_1665.class_1666.field_7594;
            }
        }
        world.method_8649(entity);
    }

    private void initProjectile(class_1665 entity, class_1799 stack, float pullProgress) {
        int punchLevel;
        int powerLevel;
        if (pullProgress == 1.0f) {
            entity.method_7439(true);
        }
        if ((powerLevel = class_1890.method_8225((class_1887)class_1893.field_9103, (class_1799)stack)) > 0) {
            entity.method_7438(entity.method_7448() + (double)powerLevel * 0.5 + 0.5);
        }
        if ((punchLevel = class_1890.method_8225((class_1887)class_1893.field_9116, (class_1799)stack)) > 0) {
            entity.method_7449(punchLevel);
        }
        if (class_1890.method_8225((class_1887)class_1893.field_9126, (class_1799)stack) > 0) {
            entity.method_5639(100);
        }
    }

    private static int getPullTimeAt(int pullTime, float progress) {
        return (int)(progress * (float)pullTime);
    }

    public record QuickChargeSounds(List<class_6880<class_3414>> levels, class_6880<class_3414> defaultSound) {
        public static final Codec<QuickChargeSounds> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_3414.field_41699.listOf().fieldOf("levels").forGetter(QuickChargeSounds::levels), (App)class_3414.field_41699.fieldOf("default").forGetter(QuickChargeSounds::defaultSound)).apply((Applicative)instance, QuickChargeSounds::new));

        public class_6880<class_3414> get(int level) {
            if (level < 0 || level >= this.levels.size()) {
                return this.defaultSound;
            }
            return this.levels.get(level);
        }

        @SafeVarargs
        public static QuickChargeSounds of(class_6880<class_3414> defaultSound, class_6880<class_3414> ... levelSounds) {
            return new QuickChargeSounds(List.of(levelSounds), defaultSound);
        }
    }

    public record Chargeable(QuickChargeSounds quickChargeSounds) {
        public static final Codec<Chargeable> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)QuickChargeSounds.CODEC.fieldOf("quick_charge_sounds").forGetter(Chargeable::quickChargeSounds)).apply((Applicative)instance, Chargeable::new));

        public static Chargeable of(QuickChargeSounds quickChargeSounds) {
            return new Chargeable(quickChargeSounds);
        }
    }
}

