/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.item.dispense.behavior;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.errorcraft.itematic.inventory.StackReferenceUtil;
import net.errorcraft.itematic.world.action.Action;
import net.errorcraft.itematic.world.action.ActionEntry;
import net.errorcraft.itematic.world.action.actions.SequenceAction;
import net.errorcraft.itematic.world.action.context.ActionContext;
import net.errorcraft.itematic.world.action.context.parameter.ActionContextParameter;
import net.errorcraft.itematic.world.action.sequence.handler.SequenceHandler;
import net.minecraft.class_1799;
import net.minecraft.class_2315;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2769;
import net.minecraft.class_2969;
import net.minecraft.class_5630;
import net.minecraft.class_6880;

public class DispenseBehavior
extends class_2969 {
    public static final Codec<DispenseBehavior> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ActionEntry.REGISTRY_CODEC.fieldOf("entry").forGetter(dispenseBehavior -> dispenseBehavior.entry), (App)Codec.BOOL.optionalFieldOf("dispense_as_item_on_failure", (Object)true).forGetter(dispenseBehavior -> dispenseBehavior.dispenseAsItemOnFailure), (App)Offset.CODEC.optionalFieldOf("offset", (Object)Offset.DEFAULT).forGetter(dispenseBehavior -> dispenseBehavior.offset)).apply((Applicative)instance, DispenseBehavior::new));
    private final class_6880<ActionEntry> entry;
    private final boolean dispenseAsItemOnFailure;
    private final Offset offset;

    public static Builder builder(class_6880<ActionEntry> entry) {
        return new Builder(entry);
    }

    public static Builder builder(ActionEntry entry) {
        return DispenseBehavior.builder((class_6880<ActionEntry>)class_6880.method_40223((Object)entry));
    }

    public static Builder builder(Action<?> action) {
        return DispenseBehavior.builder(ActionEntry.of(action));
    }

    public static Builder builder(SequenceHandler.Builder<?, ?> builder) {
        return DispenseBehavior.builder(SequenceAction.of(builder));
    }

    public DispenseBehavior(class_6880<ActionEntry> entry, boolean dispenseAsItemOnFailure, Offset offset) {
        this.entry = entry;
        this.dispenseAsItemOnFailure = dispenseAsItemOnFailure;
        this.offset = offset;
    }

    protected class_1799 method_10135(class_2342 pointer, class_1799 stack) {
        class_2350 side = (class_2350)pointer.comp_1969().method_11654((class_2769)class_2315.field_10918);
        class_5630 stackReference = StackReferenceUtil.of(stack);
        ActionContext context = ActionContext.builder(pointer.comp_1967(), stack, arg_0 -> ((class_5630)stackReference).method_32332(arg_0)).position(ActionContextParameter.THIS, pointer.comp_1968()).position(ActionContextParameter.TARGET, this.offset.position(pointer)).side(side).build();
        Optional<Boolean> result = ((ActionEntry)this.entry.comp_349()).execute(context);
        if (result.isEmpty()) {
            return super.method_10135(pointer, stack);
        }
        if (result.get().booleanValue()) {
            return this.succeed(pointer, stack, stackReference.method_32327());
        }
        return this.fail(pointer, stack);
    }

    private class_1799 succeed(class_2342 pointer, class_1799 oldStack, class_1799 newStack) {
        if (oldStack == newStack) {
            return oldStack;
        }
        if (newStack.method_7960()) {
            return super.method_10135(pointer, oldStack);
        }
        if (oldStack.method_7960()) {
            return newStack;
        }
        if (pointer.comp_1970().method_11075(newStack) < 0) {
            super.method_10135(pointer, newStack);
        }
        return oldStack;
    }

    private class_1799 fail(class_2342 pointer, class_1799 stack) {
        if (this.dispenseAsItemOnFailure) {
            return super.method_10135(pointer, stack);
        }
        this.method_27955(false);
        return stack;
    }

    public static class Builder {
        private final class_6880<ActionEntry> entry;
        private boolean dispenseAsItemOnFailure = true;
        private Offset offset = Offset.DEFAULT;

        private Builder(class_6880<ActionEntry> entry) {
            this.entry = entry;
        }

        public DispenseBehavior build() {
            return new DispenseBehavior(this.entry, this.dispenseAsItemOnFailure, this.offset);
        }

        public Builder doNotDispenseOnFailure() {
            this.dispenseAsItemOnFailure = false;
            return this;
        }

        public Builder offset(Offset offset) {
            this.offset = offset;
            return this;
        }
    }

    public record Offset(class_243 sideFactor, class_243 constant) {
        private static final class_243 DEFAULT_SIDE_FACTOR = new class_243(1.0, 1.0, 1.0);
        public static final Codec<Offset> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_243.field_38277.optionalFieldOf("side_factor", (Object)DEFAULT_SIDE_FACTOR).forGetter(Offset::sideFactor), (App)class_243.field_38277.optionalFieldOf("constant", (Object)class_243.field_1353).forGetter(Offset::constant)).apply((Applicative)instance, Offset::new));
        public static final Offset DEFAULT = new Offset(DEFAULT_SIDE_FACTOR, class_243.field_1353);

        public static Offset ofSide(double sideX, double sideY, double sideZ) {
            return new Offset(new class_243(sideX, sideY, sideZ), class_243.field_1353);
        }

        public static Offset of(double side, double constantX, double constantY, double constantZ) {
            return new Offset(new class_243(side, side, side), new class_243(constantX, constantY, constantZ));
        }

        public class_2374 position(class_2342 pointer) {
            class_2350 side = (class_2350)pointer.comp_1969().method_11654((class_2769)class_2315.field_10918);
            double offsetX = this.sideFactor.method_10216() * (double)side.method_10148() + this.constant.method_10216();
            double offsetY = this.sideFactor.method_10214() * (double)side.method_10164() + this.constant.method_10214();
            double offsetZ = this.sideFactor.method_10215() * (double)side.method_10165() + this.constant.method_10215();
            return pointer.method_53906().method_1031(offsetX, offsetY, offsetZ);
        }
    }
}

