/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.item.placement;

import net.errorcraft.itematic.fluid.FluidKeys;
import net.errorcraft.itematic.item.ItemStackConsumer;
import net.errorcraft.itematic.item.placement.Placer;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2402;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3486;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import net.minecraft.class_6880;

public class FluidPlacer
extends Placer {
    private final class_6880<class_3611> fluid;
    private final class_6880<class_3414> emptyingSound;
    private final class_2350 direction;
    private final boolean allowOffset;

    protected FluidPlacer(class_1799 stack, ItemStackConsumer resultStackConsumer, class_1937 world, class_2338 blockPos, class_2680 blockState, class_1657 player, class_6880<class_3611> fluid, class_6880<class_3414> emptyingSound, class_2350 direction, boolean allowOffset) {
        super(stack, resultStackConsumer, world, blockPos, blockState, player);
        this.fluid = fluid;
        this.emptyingSound = emptyingSound;
        this.direction = direction;
        this.allowOffset = allowOffset;
    }

    public static FluidPlacer of(class_1799 stack, ItemStackConsumer resultStackConsumer, class_1937 world, class_3965 hitResult, class_1657 player, class_6880<class_3611> fluid, class_6880<class_3414> emptyingSound) {
        class_2338 blockPos = hitResult.method_17777();
        return new FluidPlacer(stack, resultStackConsumer, world, blockPos, world.method_8320(blockPos), player, fluid, emptyingSound, hitResult.method_17780(), !hitResult.method_17781());
    }

    @Override
    public class_1269 place() {
        class_2338 offset = this.blockPos.method_10093(this.direction);
        if (!(this.player == null || this.world.method_8505(this.player, this.blockPos) && this.player.method_7343(offset, this.direction, this.stack))) {
            return class_1269.field_5811;
        }
        if (this.fluid.method_40225(FluidKeys.EMPTY)) {
            return this.tryDrainFluid();
        }
        class_2338 actualBlockPos = this.getActualPosition(offset);
        if (!this.tryPlaceFluid(actualBlockPos, this.allowOffset)) {
            return class_1269.field_5811;
        }
        return class_1269.method_29236((boolean)this.world.method_8608());
    }

    private class_2338 getActualPosition(class_2338 offset) {
        if (!this.allowOffset) {
            return this.blockPos;
        }
        if (this.blockState.method_26204() instanceof class_2402 && this.fluid.method_40225(FluidKeys.WATER)) {
            return this.blockPos;
        }
        return offset;
    }

    private class_1269 tryDrainFluid() {
        class_2248 class_22482 = this.blockState.method_26204();
        if (!(class_22482 instanceof class_2263)) {
            return class_1269.field_5811;
        }
        class_2263 fluidDrainable = (class_2263)class_22482;
        class_1799 drainedItemStack = fluidDrainable.method_9700(this.player, (class_1936)this.world, this.blockPos, this.blockState);
        if (drainedItemStack.method_7960()) {
            return class_1269.field_5811;
        }
        this.applyPlayerEffects(fluidDrainable, drainedItemStack);
        this.world.method_33596((class_1297)this.player, (class_6880)class_5712.field_28167, this.blockPos);
        this.resultStackConsumer.set(drainedItemStack);
        return class_1269.method_29236((boolean)this.world.method_8608());
    }

    private void applyPlayerEffects(class_2263 fluidDrainable, class_1799 drainedItemStack) {
        if (this.player == null) {
            return;
        }
        this.player.method_7259(class_3468.field_15372.itematic$getOrCreateStat(this.stack.method_41409()));
        fluidDrainable.method_32351().ifPresent(sound -> this.player.method_5783(sound, 1.0f, 1.0f));
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            class_174.field_1208.method_8932(serverPlayer, drainedItemStack);
        }
    }

    private boolean tryPlaceFluid(class_2338 pos, boolean allowOffset) {
        class_2402 fluidFillable;
        class_2248 class_22482;
        class_3611 fluid = (class_3611)this.fluid.comp_349();
        if (!(fluid instanceof class_3609)) {
            return false;
        }
        class_3609 flowableFluid = (class_3609)fluid;
        class_2680 blockState = this.world.method_8320(pos);
        boolean canPlace = blockState.method_26188(fluid);
        if (!(blockState.method_26215() || canPlace || (class_22482 = blockState.method_26204()) instanceof class_2402 && (fluidFillable = (class_2402)class_22482).method_10310(this.player, (class_1922)this.world, pos, blockState, fluid))) {
            return allowOffset && this.tryPlaceFluid(this.blockPos.method_10093(this.direction), false);
        }
        if (this.tryEvaporate(pos)) {
            return true;
        }
        if (this.tryFillWater(blockState, pos, flowableFluid)) {
            return true;
        }
        if (!this.world.method_8608() && canPlace && !blockState.method_51176()) {
            this.world.method_22352(pos, true);
        }
        if (this.world.method_8652(pos, fluid.method_15785().method_15759(), 11) || blockState.method_26227().method_15771()) {
            this.playEmptyingSound(pos);
            return true;
        }
        return false;
    }

    private boolean tryEvaporate(class_2338 pos) {
        if (!this.world.method_8597().comp_644()) {
            return false;
        }
        if (!this.fluid.method_40220(class_3486.field_15517)) {
            return false;
        }
        this.world.method_8396(this.player, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (this.world.field_9229.method_43057() - this.world.field_9229.method_43057()) * 0.8f);
        for (int i = 0; i < 8; ++i) {
            this.world.method_8406((class_2394)class_2398.field_11237, (double)pos.method_10263() + Math.random(), (double)pos.method_10264() + Math.random(), (double)pos.method_10260() + Math.random(), 0.0, 0.0, 0.0);
        }
        return true;
    }

    private boolean tryFillWater(class_2680 blockState, class_2338 pos, class_3609 flowableFluid) {
        class_2248 class_22482 = blockState.method_26204();
        if (!(class_22482 instanceof class_2402)) {
            return false;
        }
        class_2402 fluidFillable = (class_2402)class_22482;
        if (!this.fluid.method_40225(FluidKeys.WATER)) {
            return false;
        }
        fluidFillable.method_10311((class_1936)this.world, pos, blockState, flowableFluid.method_15729(false));
        this.playEmptyingSound(pos);
        return true;
    }

    private void playEmptyingSound(class_2338 pos) {
        if (this.emptyingSound == null) {
            return;
        }
        this.world.method_8396(this.player, pos, (class_3414)this.emptyingSound.comp_349(), class_3419.field_15245, 1.0f, 1.0f);
        this.world.method_33596((class_1297)this.player, (class_6880)class_5712.field_28166, pos);
    }
}

