/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.mixin.stat;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.errorcraft.itematic.access.stat.StatAccess;
import net.errorcraft.itematic.access.stat.StatTypeAccess;
import net.errorcraft.itematic.mixin.stat.StatAccessor;
import net.errorcraft.itematic.util.Util;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_3445;
import net.minecraft.class_3446;
import net.minecraft.class_3448;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6899;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3448.class})
public class StatTypeExtender<T>
implements StatTypeAccess<T> {
    @Unique
    private static final Logger LOGGER = LogUtils.getLogger();
    @Shadow
    @Final
    private class_2378<T> field_15323;
    @Unique
    private final Map<class_6880<T>, class_3445<T>> entryStats = new HashMap<class_6880<T>, class_3445<T>>();
    @Unique
    private MapCodec<class_3445<T>> codec;

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/codec/PacketCodecs;registryValue(Lnet/minecraft/registry/RegistryKey;)Lnet/minecraft/network/codec/PacketCodec;"))
    private class_9139<class_9129, class_6880<T>> createPacketCodecUseRegistryEntry(class_5321<? extends class_2378<T>> registry) {
        return class_9135.method_56383(registry);
    }

    @ModifyArg(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/codec/PacketCodec;xmap(Ljava/util/function/Function;Ljava/util/function/Function;)Lnet/minecraft/network/codec/PacketCodec;"), index=0)
    private <V, O> Function<? super class_6880<T>, ? extends class_3445<T>> xmapToStatUseRegistryEntry(Function<? super V, ? extends O> to) {
        return this::itematic$getOrCreateStat;
    }

    @ModifyArg(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/codec/PacketCodec;xmap(Ljava/util/function/Function;Ljava/util/function/Function;)Lnet/minecraft/network/codec/PacketCodec;"), index=1)
    private <V, O> Function<class_3445<T>, ? extends class_6880<T>> xmapFromStatUseRegistryEntry(Function<? super O, ? extends V> from) {
        return StatAccess::itematic$entry;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void setCodec(class_2378<T> registry, class_2561 name, CallbackInfo info) {
        this.codec = class_6899.method_40400((class_5321)this.field_15323.method_30517()).xmap(this::itematic$getOrCreateStat, StatAccess::itematic$entry).fieldOf("entry");
    }

    @Inject(method={"hasStat"}, at={@At(value="HEAD")})
    private void checkDynamicRegistry(T key, CallbackInfoReturnable<Boolean> info) {
        if (Objects.equals(this.field_15323.method_30517(), class_7924.field_41197)) {
            LOGGER.warn(Util.stackTraceMessage("Tried to check for a stat for an item from a value directly. This is no longer supported and should be modified to use a holder instead."));
        }
    }

    @Inject(method={"getOrCreateStat(Ljava/lang/Object;Lnet/minecraft/stat/StatFormatter;)Lnet/minecraft/stat/Stat;"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkDynamicRegistry(T key, class_3446 formatter, CallbackInfoReturnable<class_3445<T>> info) {
        if (Objects.equals(this.field_15323.method_30517(), class_7924.field_41197)) {
            LOGGER.warn(Util.stackTraceMessage("Tried to create and get a stat for an item from a value directly. This is no longer supported and should be modified to use a holder instead."));
            info.setReturnValue(null);
        }
    }

    @Redirect(method={"getOrCreateStat(Ljava/lang/Object;Lnet/minecraft/stat/StatFormatter;)Lnet/minecraft/stat/Stat;"}, at=@At(value="INVOKE", target="Ljava/util/Map;computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;", remap=false))
    private <K, V> V computeIfAbsentUseRegistryEntry(Map<K, V> instance, K k, Function<? super K, ? extends V> mappingFunction, T key, class_3446 formatter) {
        return (V)this.itematic$getOrCreateStat(this.field_15323.method_47983(key), formatter);
    }

    @Override
    public MapCodec<class_3445<T>> itematic$codec() {
        return this.codec;
    }

    @Override
    public boolean itematic$hasStat(class_6880<T> entry) {
        return this.entryStats.containsKey(entry);
    }

    @Override
    public class_3445<T> itematic$getOrCreateStat(class_6880<T> entry, class_3446 formatter) {
        return this.entryStats.computeIfAbsent(entry, value -> {
            class_3445<Object> stat = StatAccessor.create((class_3448)this, value.comp_349(), formatter);
            stat.itematic$setEntry(value);
            return stat;
        });
    }
}

