/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public abstract class Range<T extends Comparable<T>> {
    public static final Codec<IntegerRange> INT_CODEC = Codec.lazyInitialized(() -> Range.createCodec(Codec.INT, Integer.MIN_VALUE, Integer.MAX_VALUE, IntegerRange::new, IntegerRange::of));
    public static final Codec<FloatRange> FLOAT_CODEC = Codec.lazyInitialized(() -> Range.createCodec(Codec.FLOAT, Float.valueOf(-3.4028235E38f), Float.valueOf(Float.MAX_VALUE), FloatRange::new, FloatRange::of));
    public static final Codec<DoubleRange> DOUBLE_CODEC = Codec.lazyInitialized(() -> Range.createCodec(Codec.DOUBLE, -1.7976931348623157E308, Double.MAX_VALUE, DoubleRange::new, DoubleRange::of));
    protected final T min;
    protected final T max;

    protected Range(T min, T max) {
        if (max.compareTo(min) < 0) {
            throw new IllegalArgumentException("The maximum (" + String.valueOf(max) + ") must be at least the minimum (" + String.valueOf(min) + ")");
        }
        this.min = min;
        this.max = max;
    }

    @NotNull
    public abstract T get(class_5819 var1);

    @NotNull
    public T min() {
        return this.min;
    }

    @NotNull
    public T max() {
        return this.max;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Range) {
            Range that = (Range)obj;
            return Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public String toString() {
        return "Range[min=" + String.valueOf(this.min) + ", max=" + String.valueOf(this.max) + "]";
    }

    private static <T extends Comparable<T>, S extends Range<T>> Codec<S> createCodec(Codec<T> codec, T min, T max, BiFunction<T, T, S> creator, Function<T, S> singleValueCreator) {
        Codec elementCodec = RecordCodecBuilder.create(instance -> instance.group((App)codec.optionalFieldOf("min", (Object)min).forGetter(Range::min), (App)codec.optionalFieldOf("max", (Object)max).forGetter(Range::max)).apply((Applicative)instance, creator));
        return Codec.either(codec, (Codec)elementCodec).xmap(either -> (Range)either.map(singleValueCreator, s -> s), s -> {
            if (s.min.compareTo(s.max) == 0) {
                return Either.left(s.min);
            }
            return Either.right((Object)s);
        }).validate(Range::validate);
    }

    private static <T extends Comparable<T>, S extends Range<T>> DataResult<S> validate(S s) {
        if (s.max.compareTo(s.min) < 0) {
            return DataResult.error(() -> "Max must be at least min: " + String.valueOf(s));
        }
        return DataResult.success(s);
    }

    public static class DoubleRange
    extends Range<Double> {
        private DoubleRange(double min, double max) {
            super(min, max);
        }

        @Override
        @NotNull
        public Double get(class_5819 random) {
            if (((Double)this.min).equals(this.max)) {
                return (Double)this.min;
            }
            return random.method_43058() * ((Double)this.max - (Double)this.min) + (Double)this.min;
        }

        public static DoubleRange of(double min, double max) {
            return new DoubleRange(min, max);
        }

        public static DoubleRange of(double value) {
            return new DoubleRange(value, value);
        }
    }

    public static class FloatRange
    extends Range<Float> {
        private FloatRange(float min, float max) {
            super(Float.valueOf(min), Float.valueOf(max));
        }

        @Override
        @NotNull
        public Float get(class_5819 random) {
            if (((Float)this.min).equals(this.max)) {
                return (Float)this.min;
            }
            return Float.valueOf(random.method_43057() * (((Float)this.max).floatValue() - ((Float)this.min).floatValue()) + ((Float)this.min).floatValue());
        }

        public static FloatRange of(float min, float max) {
            return new FloatRange(min, max);
        }

        public static FloatRange of(float value) {
            return new FloatRange(value, value);
        }
    }

    public static class IntegerRange
    extends Range<Integer> {
        private IntegerRange(int min, int max) {
            super(min, max);
        }

        @Override
        @NotNull
        public Integer get(class_5819 random) {
            if (((Integer)this.min).equals(this.max)) {
                return (Integer)this.min;
            }
            return random.method_43048((Integer)this.max - (Integer)this.min + 1) + (Integer)this.min;
        }

        public static IntegerRange of(int min, int max) {
            return new IntegerRange(min, max);
        }

        public static IntegerRange of(int value) {
            return new IntegerRange(value, value);
        }

        public static IntegerRange atLeast(int min) {
            return new IntegerRange(min, Integer.MAX_VALUE);
        }
    }
}

