/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.world.action.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.errorcraft.itematic.item.ItemUsageUtil;
import net.errorcraft.itematic.world.action.Action;
import net.errorcraft.itematic.world.action.ActionType;
import net.errorcraft.itematic.world.action.ActionTypes;
import net.errorcraft.itematic.world.action.context.ActionContext;
import net.errorcraft.itematic.world.action.context.parameter.ActionContextParameter;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6899;
import net.minecraft.class_7924;
import net.minecraft.class_9326;

public record ExchangeItemAction(class_6880<class_1792> item, class_9326 components, boolean decrementCount) implements Action<ExchangeItemAction>
{
    public static final MapCodec<ExchangeItemAction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6899.method_40400((class_5321)class_7924.field_41197).fieldOf("item").forGetter(ExchangeItemAction::item), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(ExchangeItemAction::components), (App)Codec.BOOL.optionalFieldOf("decrement_count", (Object)true).forGetter(ExchangeItemAction::decrementCount)).apply((Applicative)instance, ExchangeItemAction::new));

    public static ExchangeItemAction of(class_6880<class_1792> item) {
        return new ExchangeItemAction(item, class_9326.field_49588, true);
    }

    public static ExchangeItemAction ofNoDecrement(class_6880<class_1792> item) {
        return new ExchangeItemAction(item, class_9326.field_49588, false);
    }

    public static ExchangeItemAction of(class_6880<class_1792> item, class_9326 components) {
        return new ExchangeItemAction(item, components, true);
    }

    @Override
    public ActionType<ExchangeItemAction> type() {
        return ActionTypes.EXCHANGE_ITEM;
    }

    @Override
    public boolean execute(ActionContext context) {
        class_1799 resultStack = this.exchange(new class_1799(this.item, 1, this.components), context);
        context.setResultStack(resultStack);
        return true;
    }

    public class_1799 exchange(class_1799 resultStack, ActionContext context) {
        return context.player(ActionContextParameter.THIS).map(player -> ItemUsageUtil.exchangeStack(context.stack(), player, resultStack, true, this.decrementCount)).orElseGet(() -> {
            class_1799 stack = context.stack();
            if (this.decrementCount) {
                stack.method_7934(1);
            }
            if (stack.method_7960()) {
                return resultStack;
            }
            class_2347.method_10134((class_1937)context.world(), (class_1799)resultStack, (int)6, (class_2350)context.side(), (class_2374)context.position(ActionContextParameter.TARGET));
            return stack;
        });
    }
}

