/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.world.action.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.errorcraft.itematic.world.action.Action;
import net.errorcraft.itematic.world.action.ActionType;
import net.errorcraft.itematic.world.action.ActionTypes;
import net.errorcraft.itematic.world.action.context.ActionContext;
import net.errorcraft.itematic.world.action.context.parameter.ActionContextParameter;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4019;
import net.minecraft.class_5699;
import net.minecraft.class_5712;
import net.minecraft.class_6880;

public record TeleportAction(int distance, ActionContextParameter entity) implements Action<TeleportAction>
{
    public static final MapCodec<TeleportAction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.field_33442.fieldOf("distance").forGetter(TeleportAction::distance), (App)ActionContextParameter.CODEC.fieldOf("entity").forGetter(TeleportAction::entity)).apply((Applicative)instance, TeleportAction::new));
    private static final int MAX_TELEPORT_ATTEMPTS = 16;

    public static TeleportAction of(int distance, ActionContextParameter entity) {
        return new TeleportAction(distance, entity);
    }

    @Override
    public ActionType<TeleportAction> type() {
        return ActionTypes.TELEPORT;
    }

    @Override
    public boolean execute(ActionContext context) {
        Optional<class_1297> entity = context.entity(this.entity);
        if (entity.isEmpty()) {
            return false;
        }
        class_1297 class_12972 = entity.get();
        if (class_12972 instanceof class_1309) {
            class_1309 target = (class_1309)class_12972;
            return this.teleport(target, context.world());
        }
        return false;
    }

    private boolean teleport(class_1309 target, class_3218 world) {
        class_243 position = target.method_19538();
        for (int i = 0; i < 16; ++i) {
            double newX = position.method_10216() + (target.method_6051().method_43058() - 0.5) * (double)this.distance;
            double newY = class_3532.method_15350((double)(position.method_10214() + (double)target.method_6051().method_43048(this.distance) - (double)this.distance * 0.5), (double)world.method_31607(), (double)(world.method_31607() + world.method_32819() - 1));
            double newZ = position.method_10215() + (target.method_6051().method_43058() - 0.5) * (double)this.distance;
            if (target.method_5765()) {
                target.method_5848();
            }
            if (!target.method_6082(newX, newY, newZ, true)) continue;
            this.teleported(target, world, position);
            return true;
        }
        return false;
    }

    private void teleported(class_1309 target, class_3218 world, class_243 position) {
        world.method_32888((class_6880)class_5712.field_39446, position, class_5712.class_7397.method_43285((class_1297)target));
        class_3414 soundEvent = TeleportAction.getSoundEvent(target);
        world.itematic$playSound(null, position, soundEvent, class_3419.field_15248, 1.0f, 1.0f);
        target.method_5783(soundEvent, 1.0f, 1.0f);
    }

    private static class_3414 getSoundEvent(class_1309 target) {
        if (target instanceof class_4019) {
            return class_3417.field_24630;
        }
        return class_3417.field_14890;
    }
}

