/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.errorcraft.itematic.util.IdentifierUtil;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_8824;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public record ItemBase(String translationKey, class_1814 rarity, Optional<List<class_2561>> tooltip, Optional<Boolean> glint) {
    public static final Codec<ItemBase> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("translation_key").forGetter(ItemBase::translationKey), (App)class_1814.field_50001.optionalFieldOf("rarity", (Object)class_1814.field_8906).forGetter(ItemBase::rarity), (App)class_8824.field_46597.listOf().optionalFieldOf("tooltip").forGetter(ItemBase::tooltip), (App)Codec.BOOL.optionalFieldOf("glint").forGetter(ItemBase::glint)).apply((Applicative)instance, ItemBase::new));

    public void addComponents(class_9323.class_9324 builder) {
        builder.method_57840(class_9334.field_50073, (Object)this.rarity);
        this.glint.ifPresent(glint -> builder.method_57840(class_9334.field_49641, glint));
    }

    public static class Builder {
        private final String translationKey;
        private class_1814 rarity = class_1814.field_8906;
        private List<class_2561> tooltip;
        private Boolean glint;

        private Builder(String name) {
            this.translationKey = name;
        }

        public static Builder forItem(class_5321<class_1792> name) {
            return new Builder(class_156.method_646((String)"item", (class_2960)name.method_29177()));
        }

        public static Builder forBlock(class_5321<class_1792> name) {
            return new Builder(class_156.method_646((String)"block", (class_2960)name.method_29177()));
        }

        public ItemBase build() {
            return new ItemBase(this.translationKey, this.rarity, Optional.ofNullable(this.tooltip), Optional.ofNullable(this.glint));
        }

        public Builder rarity(class_1814 rarity) {
            this.rarity = rarity;
            return this;
        }

        public Builder tooltip(class_5321<class_1792> name) {
            return this.tooltip(new class_2561[]{class_2561.method_43471((String)IdentifierUtil.createTranslationKey(name, "item", "desc")).method_27692(class_124.field_1080)});
        }

        public Builder tooltip(class_2561 ... lines) {
            if (this.tooltip == null) {
                this.tooltip = new ArrayList<class_2561>();
            }
            this.tooltip.addAll(List.of(lines));
            return this;
        }

        public Builder glint() {
            this.glint = true;
            return this;
        }
    }
}

