/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.item.component.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.errorcraft.itematic.item.armor.ArmorMaterial;
import net.errorcraft.itematic.item.component.ItemComponent;
import net.errorcraft.itematic.item.component.ItemComponentSet;
import net.errorcraft.itematic.item.component.ItemComponentType;
import net.errorcraft.itematic.item.component.ItemComponentTypes;
import net.errorcraft.itematic.item.component.components.DamageableItemComponent;
import net.errorcraft.itematic.item.component.components.EquipmentItemComponent;
import net.errorcraft.itematic.item.component.components.StackableItemComponent;
import net.errorcraft.itematic.registry.ItematicRegistryKeys;
import net.minecraft.class_1304;
import net.minecraft.class_1738;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3542;
import net.minecraft.class_4059;
import net.minecraft.class_6880;
import net.minecraft.class_6899;
import net.minecraft.class_9285;

public record ArmorItemComponent(class_6880<ArmorMaterial> material, Optional<class_4059.class_9076> armorType) implements ItemComponent<ArmorItemComponent>
{
    public static final Codec<ArmorItemComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6899.method_40400(ItematicRegistryKeys.ARMOR_MATERIAL).fieldOf("material").forGetter(ArmorItemComponent::material), (App)class_3542.method_28140(class_4059.class_9076::values).optionalFieldOf("armor_type").forGetter(ArmorItemComponent::armorType)).apply((Applicative)instance, ArmorItemComponent::new));

    public static ArmorItemComponent of(class_6880<ArmorMaterial> material) {
        return new ArmorItemComponent(material, Optional.empty());
    }

    public static ArmorItemComponent of(class_6880<ArmorMaterial> material, class_4059.class_9076 armorType) {
        return new ArmorItemComponent(material, Optional.of(armorType));
    }

    public static ItemComponent<?>[] of(class_1738.class_8051 type, int damageFactor, class_6880<ArmorMaterial> material, class_6880<class_3414> equipSound) {
        return new ItemComponent[]{StackableItemComponent.of(1), DamageableItemComponent.of(type.method_56690(damageFactor)), EquipmentItemComponent.of(type.method_48399(), true, equipSound), ArmorItemComponent.of(material)};
    }

    public static ItemComponent<?>[] of(int durability, class_1304 slot, class_6880<ArmorMaterial> material, class_6880<class_3414> equipSound) {
        return new ItemComponent[]{StackableItemComponent.of(1), DamageableItemComponent.of(durability), EquipmentItemComponent.of(slot, true, equipSound), ArmorItemComponent.of(material)};
    }

    public static ItemComponent<?>[] ofAnimal(class_6880<ArmorMaterial> material, class_6880<class_3414> equipSound, class_4059.class_9076 type) {
        return new ItemComponent[]{StackableItemComponent.of(1), EquipmentItemComponent.of(class_1304.field_48824, false, equipSound), ArmorItemComponent.of(material, type)};
    }

    public static ItemComponent<?>[] ofAnimal(class_6880<ArmorMaterial> material, class_6880<class_3414> equipSound, class_4059.class_9076 type, int damageFactor, class_6880<class_3414> breakSound) {
        return new ItemComponent[]{StackableItemComponent.of(1), DamageableItemComponent.of(class_1738.class_8051.field_48838.method_56690(damageFactor), breakSound), EquipmentItemComponent.of(class_1304.field_48824, false, equipSound), ArmorItemComponent.of(material, type)};
    }

    @Override
    public ItemComponentType<ArmorItemComponent> type() {
        return ItemComponentTypes.ARMOR;
    }

    @Override
    public Codec<ArmorItemComponent> codec() {
        return CODEC;
    }

    @Override
    public void addAttributeModifiers(class_9285.class_9286 builder, ItemComponentSet components) {
        if (!this.material.method_40227()) {
            return;
        }
        components.get(ItemComponentTypes.EQUIPMENT).ifPresent(c -> ((ArmorMaterial)this.material.comp_349()).addAttributes(builder, c.slot()));
    }

    public class_2960 textureId() {
        return this.armorType.map(type -> type.itematic$textureId(this.material)).orElseGet(() -> this.textureId(false));
    }

    public class_2960 textureId(boolean secondLayer) {
        return ((ArmorMaterial)this.material.comp_349()).textureId(secondLayer);
    }
}

