/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.item.component.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.errorcraft.itematic.item.ItemStackConsumer;
import net.errorcraft.itematic.item.component.ItemComponent;
import net.errorcraft.itematic.item.component.ItemComponentType;
import net.errorcraft.itematic.item.component.ItemComponentTypes;
import net.errorcraft.itematic.mixin.item.BundleItemAccessor;
import net.errorcraft.itematic.util.Util;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3468;
import net.minecraft.class_5328;
import net.minecraft.class_5536;
import net.minecraft.class_5631;
import net.minecraft.class_5632;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_9276;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.apache.commons.lang3.math.Fraction;

public record ItemHolderItemComponent(int capacity, class_6880<class_3414> insertItemSound, class_6880<class_3414> removeItemSound, class_6880<class_3414> emptySound) implements ItemComponent<ItemHolderItemComponent>
{
    public static final Codec<ItemHolderItemComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33442.fieldOf("capacity").forGetter(ItemHolderItemComponent::capacity), (App)class_3414.field_41699.fieldOf("insert_item_sound").forGetter(ItemHolderItemComponent::insertItemSound), (App)class_3414.field_41699.fieldOf("remove_item_sound").forGetter(ItemHolderItemComponent::removeItemSound), (App)class_3414.field_41699.fieldOf("empty_sound").forGetter(ItemHolderItemComponent::emptySound)).apply((Applicative)instance, ItemHolderItemComponent::new));
    public static final int ITEM_BAR_COLOR = BundleItemAccessor.itemBarColor();

    @Override
    public ItemComponentType<ItemHolderItemComponent> type() {
        return ItemComponentTypes.ITEM_HOLDER;
    }

    @Override
    public Codec<ItemHolderItemComponent> codec() {
        return CODEC;
    }

    @Override
    public class_1269 use(class_1937 world, class_1657 user, class_1268 hand, class_1799 stack, ItemStackConsumer resultStackConsumer) {
        if (!BundleItemAccessor.dropAllBundledItems(stack, user)) {
            return class_1269.field_5811;
        }
        user.method_5783((class_3414)this.emptySound.comp_349(), 0.8f, 0.8f + world.method_8409().method_43057() * 0.4f);
        user.method_7259(class_3468.field_15372.itematic$getOrCreateStat(stack.method_41409()));
        return class_1269.method_29236((boolean)world.method_8608());
    }

    @Override
    public boolean clickOnSlot(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 user) {
        if (clickType != class_5536.field_27014) {
            return false;
        }
        class_9276 bundleContents = (class_9276)stack.method_57824(class_9334.field_49650);
        if (bundleContents == null) {
            return false;
        }
        class_9276.class_9277 bundleContentsBuilder = new class_9276.class_9277(bundleContents);
        bundleContentsBuilder.itematic$setCapacity(this.capacity);
        if (slot.method_7677().method_7960()) {
            this.remove((class_1297)user, bundleContentsBuilder, removedStack -> this.add(bundleContentsBuilder, slot.method_32756(removedStack), user));
        } else {
            this.add(bundleContentsBuilder, slot, user);
        }
        stack.method_57379(class_9334.field_49650, (Object)bundleContentsBuilder.method_57435());
        return true;
    }

    @Override
    public boolean clickedOnWithStack(class_1799 stack, class_1799 cursorStack, class_1735 slot, class_5536 clickType, class_1657 user, ItemStackConsumer resultStackConsumer) {
        if (clickType != class_5536.field_27014 || !slot.method_32754(user)) {
            return false;
        }
        class_9276 bundleContents = (class_9276)stack.method_57824(class_9334.field_49650);
        if (bundleContents == null) {
            return false;
        }
        class_9276.class_9277 bundleContentsBuilder = new class_9276.class_9277(bundleContents);
        bundleContentsBuilder.itematic$setCapacity(this.capacity);
        if (cursorStack.method_7960()) {
            this.remove((class_1297)user, bundleContentsBuilder, resultStackConsumer::set);
        } else {
            this.add(bundleContentsBuilder, cursorStack, user);
        }
        stack.method_57379(class_9334.field_49650, (Object)bundleContentsBuilder.method_57435());
        return true;
    }

    @Override
    public void addComponents(class_9323.class_9324 builder) {
        builder.method_57840(class_9334.field_49650, (Object)class_9276.field_49289);
    }

    @Override
    public void appendTooltip(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        class_9276 bundleContents = (class_9276)stack.method_57824(class_9334.field_49650);
        if (bundleContents != null) {
            int occupancy = Util.multiplyFraction(bundleContents.method_57428(), 64);
            tooltip.add((class_2561)class_2561.method_43469((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{occupancy, this.capacity}).method_27692(class_124.field_1080));
        }
    }

    public boolean itemBarVisible(class_1799 stack) {
        class_9276 bundleContents = (class_9276)stack.method_57824(class_9334.field_49650);
        if (bundleContents == null) {
            return false;
        }
        return bundleContents.method_57428().compareTo(Fraction.ZERO) > 0;
    }

    public int itemBarStep(class_1799 stack) {
        int step = this.fullness(stack).multiplyBy(Fraction.getFraction((int)768, (int)1)).intValue();
        return Math.min(step, 13);
    }

    public Optional<class_5632> tooltipData(class_1799 stack) {
        class_9276 bundleContents = (class_9276)stack.method_57824(class_9334.field_49650);
        if (bundleContents == null) {
            return Optional.empty();
        }
        class_5631 data = new class_5631(bundleContents);
        data.itematic$setCapacity(this.capacity);
        return Optional.of(data);
    }

    public Fraction fullness(class_1799 stack) {
        class_9276 bundleContents = (class_9276)stack.method_57824(class_9334.field_49650);
        if (bundleContents == null) {
            return Fraction.ZERO;
        }
        return bundleContents.method_57428().multiplyBy(Fraction.getFraction((int)1, (int)this.capacity));
    }

    public void onDestroyed(class_1542 item) {
        class_9276 bundleContents = (class_9276)item.method_6983().method_57824(class_9334.field_49650);
        if (bundleContents != null) {
            class_5328.method_33263((class_1542)item, (Iterable)bundleContents.method_59708());
        }
    }

    public static ItemHolderItemComponent of(int capacity, class_6880<class_3414> insertItemSound, class_6880<class_3414> removeItemSound, class_6880<class_3414> emptySound) {
        return new ItemHolderItemComponent(capacity, insertItemSound, removeItemSound, emptySound);
    }

    private void add(class_9276.class_9277 bundleContentsBuilder, class_1799 stack, class_1657 user) {
        int addedCount = bundleContentsBuilder.method_57432(stack);
        if (addedCount > 0) {
            this.playInsertItemSound(user);
        }
    }

    private void add(class_9276.class_9277 bundleContentsBuilder, class_1735 slot, class_1657 user) {
        int addedCount = bundleContentsBuilder.method_57431(slot, user);
        if (addedCount > 0) {
            this.playInsertItemSound(user);
        }
    }

    private void remove(class_1297 user, class_9276.class_9277 bundleContentsBuilder, Consumer<class_1799> onRemoved) {
        class_1937 world = user.method_37908();
        class_1799 removedStack = bundleContentsBuilder.method_57430();
        if (removedStack == null) {
            return;
        }
        user.method_5783((class_3414)this.removeItemSound.comp_349(), 0.8f, 0.8f + world.method_8409().method_43057() * 0.4f);
        onRemoved.accept(removedStack);
    }

    private void playInsertItemSound(class_1657 user) {
        user.method_5783((class_3414)this.insertItemSound.comp_349(), 0.8f, 0.8f + user.method_37908().method_8409().method_43057() * 0.4f);
    }
}

