/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.item.component.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.errorcraft.itematic.item.component.ItemComponent;
import net.errorcraft.itematic.item.component.ItemComponentType;
import net.errorcraft.itematic.item.component.ItemComponentTypes;
import net.errorcraft.itematic.item.pointer.Pointer;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_9291;
import net.minecraft.class_9334;

public record PointableItemComponent(class_6880<Pointer> pointsTo, Optional<String> lodestoneTranslationKey) implements ItemComponent<PointableItemComponent>
{
    public static final Codec<PointableItemComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Pointer.ENTRY_CODEC.fieldOf("points_to").forGetter(PointableItemComponent::pointsTo), (App)Codec.STRING.optionalFieldOf("lodestone_translation_key").forGetter(PointableItemComponent::lodestoneTranslationKey)).apply((Applicative)instance, PointableItemComponent::new));

    @Override
    public ItemComponentType<PointableItemComponent> type() {
        return ItemComponentTypes.POINTABLE;
    }

    @Override
    public Codec<PointableItemComponent> codec() {
        return CODEC;
    }

    @Override
    public void inventoryTick(class_1799 stack, class_1937 world, class_1297 holder, int slot, boolean selected) {
        if (this.lodestoneTranslationKey.isEmpty()) {
            return;
        }
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        class_9291 lodestoneTracker = (class_9291)stack.method_57824(class_9334.field_49614);
        if (lodestoneTracker == null) {
            return;
        }
        class_9291 lodestoneTrackerForCurrentWorld = lodestoneTracker.method_58115(serverWorld);
        if (lodestoneTrackerForCurrentWorld != lodestoneTracker) {
            stack.method_57379(class_9334.field_49614, (Object)lodestoneTrackerForCurrentWorld);
        }
    }

    public Optional<String> lodestoneTranslationKey(class_1799 stack) {
        if (stack.method_57826(class_9334.field_49614)) {
            return this.lodestoneTranslationKey;
        }
        return Optional.empty();
    }

    public static PointableItemComponent of(class_6880<Pointer> pointsTo) {
        return new PointableItemComponent(pointsTo, Optional.empty());
    }

    public static PointableItemComponent of(class_6880<Pointer> pointsTo, String lodestoneTranslationKey) {
        return new PointableItemComponent(pointsTo, Optional.of(lodestoneTranslationKey));
    }
}

