/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.item.component.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.errorcraft.itematic.entity.initializer.EntityInitializer;
import net.errorcraft.itematic.entity.initializer.initializers.PersistentProjectileEntityInitializer;
import net.errorcraft.itematic.entity.initializer.initializers.SimpleEntityInitializer;
import net.errorcraft.itematic.item.ItemStackConsumer;
import net.errorcraft.itematic.item.component.ItemComponent;
import net.errorcraft.itematic.item.component.ItemComponentType;
import net.errorcraft.itematic.item.component.ItemComponentTypes;
import net.errorcraft.itematic.mixin.item.CrossbowItemAccessor;
import net.errorcraft.itematic.serialization.ItematicCodecs;
import net.errorcraft.itematic.world.action.context.ActionContext;
import net.errorcraft.itematic.world.action.context.parameter.ActionContextParameter;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1668;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_3218;
import net.minecraft.class_3857;
import net.minecraft.class_5699;
import net.minecraft.class_6880;

public record ProjectileItemComponent(EntityInitializer<?> entity, int damage, float chargedSpeed) implements ItemComponent<ProjectileItemComponent>
{
    public static final Codec<ProjectileItemComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityInitializer.CODEC.fieldOf("entity").forGetter(ProjectileItemComponent::entity), (App)class_5699.field_33441.optionalFieldOf("damage", (Object)0).forGetter(ProjectileItemComponent::damage), (App)ItematicCodecs.NON_NEGATIVE_FLOAT.optionalFieldOf("charged_speed", (Object)Float.valueOf(CrossbowItemAccessor.defaultSpeed())).forGetter(ProjectileItemComponent::chargedSpeed)).apply((Applicative)instance, ProjectileItemComponent::new));

    public static ProjectileItemComponent of(EntityInitializer<?> entity, int damage, float chargedSpeed) {
        return new ProjectileItemComponent(entity, damage, chargedSpeed);
    }

    public static ProjectileItemComponent of(EntityInitializer<?> entity, int damage) {
        return ProjectileItemComponent.of(entity, damage, CrossbowItemAccessor.defaultSpeed());
    }

    public static ProjectileItemComponent of(class_6880<class_1299<?>> entity) {
        return ProjectileItemComponent.of(SimpleEntityInitializer.of((class_1299)entity.comp_349()), 0);
    }

    public static <U extends class_1665> ProjectileItemComponent persistentProjectile(class_1299<U> entityType, PersistentProjectileEntityInitializer.OwnerCreator<U> ownerCreator, PersistentProjectileEntityInitializer.SimpleCreator<U> simpleCreator) {
        return ProjectileItemComponent.of(new PersistentProjectileEntityInitializer<U>(entityType, ownerCreator, simpleCreator), 1);
    }

    @Override
    public ItemComponentType<ProjectileItemComponent> type() {
        return ItemComponentTypes.PROJECTILE;
    }

    @Override
    public Codec<ProjectileItemComponent> codec() {
        return CODEC;
    }

    public class_1297 createEntity(class_1937 world, class_1297 user, class_1799 stack, float angleOffset, float speed) {
        if (world.method_8608()) {
            return null;
        }
        return this.createEntity((class_3218)world, user, stack, ItemStackConsumer.EMPTY, angleOffset, speed, 1.0f);
    }

    public class_1297 createEntity(class_3218 world, class_1297 user, class_1799 stack, ItemStackConsumer resultStackConsumer, float angleOffset, float speed, float uncertainty) {
        ActionContext context = ActionContext.builder(world, stack, resultStackConsumer).entityPosition(ActionContextParameter.THIS, user).position(ActionContextParameter.TARGET, user.method_33571().method_1031(0.0, -0.1, 0.0)).build();
        return this.createEntity(context, ActionContextParameter.TARGET, angleOffset, speed, uncertainty);
    }

    public class_1297 createEntity(class_1937 world, class_2374 position, class_1799 stack, float speed, float uncertainty) {
        if (world.method_8608()) {
            return null;
        }
        ActionContext context = ActionContext.builder((class_3218)world, stack, ItemStackConsumer.EMPTY).position(ActionContextParameter.TARGET, position).build();
        return this.createEntity(context, ActionContextParameter.TARGET, 0.0f, speed, uncertainty);
    }

    public class_1297 createEntity(ActionContext context, ActionContextParameter position, float angleOffset, float speed, float uncertainty) {
        Object entity = this.entity.create(context);
        if (entity == null) {
            return null;
        }
        entity.method_29495(context.position(position));
        if (entity instanceof class_3857) {
            class_3857 thrownItemEntity = (class_3857)entity;
            thrownItemEntity.method_16940(context.stack());
        }
        if (entity instanceof class_1676) {
            class_1676 projectileEntity = (class_1676)entity;
            this.initializeProjectile(context, projectileEntity, angleOffset, speed, uncertainty);
        }
        return entity;
    }

    private void initializeProjectile(ActionContext context, class_1676 projectileEntity, float angleOffset, float speed, float uncertainty) {
        context.entity(ActionContextParameter.THIS).ifPresentOrElse(user -> this.initializeProjectile(projectileEntity, (class_1297)user, angleOffset, speed, uncertainty), () -> this.initializeProjectile(projectileEntity, context.side(), speed, uncertainty));
    }

    private void initializeProjectile(class_1676 entity, class_2350 side, float speed, float uncertainty) {
        if (entity instanceof class_1668) {
            return;
        }
        entity.method_7485((double)side.method_10148(), (double)side.method_10164(), (double)side.method_10165(), speed, uncertainty);
    }

    private void initializeProjectile(class_1676 entity, class_1297 user, float angleOffset, float speed, float uncertainty) {
        entity.method_7432(user);
        if (entity instanceof class_1665) {
            class_1657 player;
            class_1665 persistentProjectileEntity = (class_1665)entity;
            if (user instanceof class_1657 && (player = (class_1657)user).method_56992()) {
                persistentProjectileEntity.field_7572 = class_1665.class_1666.field_7594;
            }
        }
        if (entity instanceof class_1668) {
            return;
        }
        entity.method_24919(user, user.method_36455(), user.method_36454(), angleOffset, speed, uncertainty);
    }
}

