/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.item.model.override.overrides;

import net.errorcraft.itematic.item.component.ItemComponentTypes;
import net.errorcraft.itematic.item.component.components.PointableItemComponent;
import net.errorcraft.itematic.item.model.override.ModelOverride;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4208;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class AngleModelOverride
implements ModelOverride {
    private static final float INTERPOLATION_FACTOR = 0.8f;
    private static final double DISTANCE_EPSILON = 1.0E-5;
    private static final Interpolator INTERPOLATOR = new Interpolator(0.8f);
    private static final Interpolator AIMLESS_INTERPOLATOR = new Interpolator(0.8f);

    @Override
    public float apply(class_1799 stack, @Nullable class_1937 world, @Nullable class_1309 target, int seed) {
        if (world == null) {
            return 0.0f;
        }
        if (target == null) {
            return 0.0f;
        }
        return stack.itematic$getComponent(ItemComponentTypes.POINTABLE).map(PointableItemComponent::pointsTo).map(class_6880::comp_349).map(p -> Float.valueOf(this.getAngle(p.createPos(stack, world, (class_1297)target), (class_1297)target, world))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public boolean isApplicable(class_1799 stack) {
        return stack.itematic$hasComponent(ItemComponentTypes.POINTABLE);
    }

    private float getAngle(class_4208 pos, class_1297 target, class_1937 world) {
        if (this.canPointTo(target, pos)) {
            return this.getAngle(pos.comp_2208(), target, world);
        }
        return AIMLESS_INTERPOLATOR.update(world, world.method_8409().method_43057());
    }

    private boolean canPointTo(class_1297 target, class_4208 pos) {
        return pos != null && pos.comp_2207() == target.method_37908().method_27983() && pos.comp_2208().method_19770((class_2374)target.method_19538()) >= 1.0E-5;
    }

    private float getAngle(class_2338 pos, class_1297 target, class_1937 world) {
        float entityAngle = this.getNormalizedAngle(target, pos);
        float entityRotation = this.getNormalizedEntityRotation(target);
        float interpolatedAngle = INTERPOLATOR.update(world, 0.5f - (entityRotation - 0.25f));
        return class_3532.method_15341((float)(entityAngle + interpolatedAngle), (float)1.0f);
    }

    private float getNormalizedAngle(class_1297 target, class_2338 pos) {
        class_243 centerPos = class_243.method_24953((class_2382)pos);
        return (float)(Math.atan2(centerPos.method_10215() - target.method_23321(), centerPos.method_10216() - target.method_23317()) / (Math.PI * 2));
    }

    private float getNormalizedEntityRotation(class_1297 target) {
        return class_3532.method_15341((float)(target.method_43078() / 360.0f), (float)1.0f);
    }

    public static class Interpolator {
        private final float interpolationFactor;
        private long lastTick;
        private float value;
        private float speed;

        public Interpolator(float interpolationFactor) {
            this.interpolationFactor = interpolationFactor;
        }

        public float update(class_1937 world, float angle) {
            long currentTick = world.method_8510();
            if (currentTick == this.lastTick) {
                return this.value;
            }
            this.lastTick = currentTick;
            float deltaValue = class_3532.method_15341((float)(angle - this.value + 0.5f), (float)1.0f) - 0.5f;
            this.speed += deltaValue * 0.1f;
            this.speed *= this.interpolationFactor;
            this.value = class_3532.method_15341((float)(this.value + this.speed), (float)1.0f);
            return this.value;
        }
    }
}

