/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.item.placement;

import java.util.Map;
import net.errorcraft.itematic.access.block.entity.BlockEntityAccess;
import net.errorcraft.itematic.block.BlockStateUtil;
import net.errorcraft.itematic.block.ShapeContextUtil;
import net.errorcraft.itematic.item.ItemStackConsumer;
import net.errorcraft.itematic.item.event.ItemEvents;
import net.errorcraft.itematic.item.placement.Placer;
import net.errorcraft.itematic.item.placement.block.picker.BlockPicker;
import net.errorcraft.itematic.mixin.block.BlockItemAccessor;
import net.errorcraft.itematic.world.action.context.ActionContext;
import net.errorcraft.itematic.world.action.context.parameter.ActionContextParameter;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2968;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9275;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class BlockPlacer
extends Placer {
    private final BlockPicker<?> block;
    private final class_1750 context;
    private final boolean operatorOnly;
    private final boolean decrementStack;

    public BlockPlacer(class_1799 stack, ItemStackConsumer resultStackConsumer, class_1937 world, class_2338 blockPos, class_2680 blockState, class_1657 player, BlockPicker<?> block, class_1750 context, boolean operatorOnly, boolean decrementStack) {
        super(stack, resultStackConsumer, world, blockPos, blockState, player);
        this.block = block;
        this.context = context;
        this.operatorOnly = operatorOnly;
        this.decrementStack = decrementStack;
    }

    public static BlockPlacer of(ActionContext context, ActionContextParameter position, BlockPicker<?> block, boolean operatorOnly, boolean decrementStack) {
        return BlockPlacer.of(context.createItemPlacementContext(position, block.defaultBlock()), context.resultStackConsumer(), block, operatorOnly, decrementStack);
    }

    public static BlockPlacer of(class_1838 context, ItemStackConsumer resultStackConsumer, BlockPicker<?> block, boolean operatorOnly, boolean decrementStack) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2350 side = context.method_8038();
        class_1750 placementContext = block.placementContext((class_1750)(context.method_8036() != null ? new class_1750(context) : new class_2968(world, pos, side, context.method_8041(), world.method_22347(pos.method_10074()) ? side : class_2350.field_11036)));
        return BlockPlacer.of(placementContext, resultStackConsumer, block, operatorOnly, decrementStack);
    }

    public static BlockPlacer of(class_1750 context, ItemStackConsumer resultStackConsumer, BlockPicker<?> block, boolean operatorOnly, boolean decrementStack) {
        class_1937 world = context.method_8045();
        class_2338 blockPos = context.method_8037();
        return new BlockPlacer(context.method_8041(), resultStackConsumer, world, blockPos, world.method_8320(blockPos), context.method_8036(), block, context, operatorOnly, decrementStack);
    }

    @Override
    public class_1269 place() {
        if (!this.context.method_7716()) {
            return class_1269.field_5811;
        }
        class_2680 blockState = this.getPlacementState();
        if (blockState == null) {
            return class_1269.field_5811;
        }
        if (!this.world.method_8652(this.blockPos, blockState, 11)) {
            return class_1269.field_5811;
        }
        this.placed(blockState);
        return class_1269.method_29236((boolean)this.world.method_8608());
    }

    private void placed(class_2680 blockState) {
        blockState = this.placeFromNbt(blockState);
        class_2586 blockEntity = this.world.method_8321(this.blockPos);
        if (blockEntity != null) {
            ((BlockEntityAccess)blockEntity).itematic$placedFromItemStack(this.world, this.player, blockState, this.blockPos, this.stack);
        }
        BlockItemAccessor.copyComponentsToBlockEntity(this.world, this.blockPos, this.stack);
        blockState.method_26204().method_9567(this.world, this.blockPos, blockState, (class_1309)this.player, this.stack);
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            class_174.field_1191.method_23889(serverPlayer, this.blockPos, this.stack);
            ActionContext context = ActionContext.builder(serverPlayer.method_51469(), this.stack, this.resultStackConsumer, this.context.method_20287()).entityPosition(ActionContextParameter.THIS, (class_1297)serverPlayer).position(ActionContextParameter.TARGET, this.blockPos).build();
            this.stack.itematic$invokeEvent(ItemEvents.PLACED_BLOCK, context);
        }
        class_2498 blockSoundGroup = blockState.method_26231();
        this.world.method_8396(this.player, this.blockPos, blockSoundGroup.method_10598(), class_3419.field_15245, (blockSoundGroup.method_10597() + 1.0f) / 2.0f, blockSoundGroup.method_10599() * 0.8f);
        this.world.method_43276((class_6880)class_5712.field_28164, this.blockPos, class_5712.class_7397.method_43286((class_1297)this.player, (class_2680)blockState));
        if (this.decrementStack) {
            this.tryDecrementStack();
        }
    }

    @Nullable
    private class_2680 getPlacementState() {
        if (this.operatorOnly && this.player != null && !this.player.method_7338()) {
            return null;
        }
        class_2680 state = this.block.placementState(this.context);
        return this.canPlace(state) ? state : null;
    }

    private boolean canPlace(class_2680 state) {
        if (state == null) {
            return false;
        }
        class_3726 shapeContext = ShapeContextUtil.ofNullable((class_1297)this.player);
        return state.method_26184((class_4538)this.world, this.blockPos) && this.world.method_8628(state, this.blockPos, shapeContext);
    }

    private class_2680 placeFromNbt(class_2680 state) {
        class_2680 blockState = state;
        class_9275 blockStates = (class_9275)this.stack.method_57824(class_9334.field_49623);
        if (blockStates != null) {
            class_2689 stateManager = state.method_26204().method_9595();
            for (Map.Entry entry : blockStates.comp_2381().entrySet()) {
                class_2769 property = stateManager.method_11663((String)entry.getKey());
                if (property == null) continue;
                blockState = BlockStateUtil.with(blockState, property, (String)entry.getValue());
            }
        }
        if (blockState != state) {
            this.world.method_8652(this.blockPos, blockState, 2);
        }
        return blockState;
    }
}

