/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.item.placement;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.errorcraft.itematic.entity.initializer.EntityInitializer;
import net.errorcraft.itematic.item.ItemStackConsumer;
import net.errorcraft.itematic.item.component.ItemComponentTypes;
import net.errorcraft.itematic.item.component.components.BucketItemComponent;
import net.errorcraft.itematic.item.component.components.EntityItemComponent;
import net.errorcraft.itematic.item.event.ItemEvents;
import net.errorcraft.itematic.item.placement.Placer;
import net.errorcraft.itematic.world.action.context.ActionContext;
import net.errorcraft.itematic.world.action.context.parameter.ActionContextParameter;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import net.minecraft.class_6880;

public class EntityPlacer
extends Placer {
    private final EntityInitializer<?> initializer;
    private final class_2350 direction;
    private final boolean mayModifyBlock;
    private final class_3730 spawnReason;
    private final BiConsumer<class_1297, class_1799> spawnCallback;
    private final boolean allowItemData;
    private final class_1268 hand;

    public EntityPlacer(class_1799 stack, ItemStackConsumer resultStackConsumer, class_1937 world, class_2338 blockPos, class_2680 blockState, class_1657 player, EntityInitializer<?> initializer, class_2350 direction, boolean mayModifyBlock, class_3730 spawnReason, BiConsumer<class_1297, class_1799> spawnCallback, boolean allowItemData, class_1268 hand) {
        super(stack, resultStackConsumer, world, blockPos, blockState, player);
        this.initializer = initializer;
        this.direction = direction;
        this.mayModifyBlock = mayModifyBlock;
        this.spawnReason = spawnReason;
        this.spawnCallback = spawnCallback;
        this.allowItemData = allowItemData;
        this.hand = hand;
    }

    public static EntityPlacer spawned(class_1838 context, class_1799 stack, ItemStackConsumer resultStackConsumer, EntityItemComponent entityItemComponent) {
        class_1937 world = context.method_8045();
        class_2338 blockPos = context.method_8037();
        return new EntityPlacer(context.method_8041(), resultStackConsumer, world, blockPos, world.method_8320(blockPos), context.method_8036(), entityItemComponent.getEntityInitializer(stack), context.method_8038(), true, class_3730.field_16465, null, entityItemComponent.allowItemData(), context.method_20287());
    }

    public static EntityPlacer action(ActionContext context, ActionContextParameter position, EntityItemComponent entityItemComponent) {
        class_1799 stack = context.stack();
        class_2338 pos = context.blockPos(position);
        return new EntityPlacer(stack, context.resultStackConsumer(), (class_1937)context.world(), pos, context.world().method_8320(pos), context.player(ActionContextParameter.THIS).orElse(null), entityItemComponent.getEntityInitializer(stack), context.side(), false, class_3730.field_16462, null, entityItemComponent.allowItemData(), context.hand());
    }

    public static EntityPlacer action(ActionContext context, ActionContextParameter position, EntityInitializer<?> entityInitializer) {
        class_1799 stack = context.stack();
        class_2338 pos = context.blockPos(position);
        return new EntityPlacer(stack, context.resultStackConsumer(), (class_1937)context.world(), pos, context.world().method_8320(pos), context.player(ActionContextParameter.THIS).orElse(null), entityInitializer, context.side(), false, class_3730.field_16462, null, false, context.hand());
    }

    public static EntityPlacer bucket(class_1799 stack, ItemStackConsumer resultStackConsumer, class_1937 world, class_3965 result, class_1657 player, EntityInitializer<?> initializer, class_1268 hand) {
        class_2338 blockPos = result.method_17777();
        return new EntityPlacer(stack, resultStackConsumer, world, blockPos, world.method_8320(blockPos), player, initializer, result.method_17780(), false, class_3730.field_16473, BucketItemComponent::initializeBucketEntity, true, hand);
    }

    @Override
    public class_1269 place() {
        if (!this.mayModifyBlock || !this.tryModifySpawnerBlock()) {
            this.placeEntity();
        }
        return class_1269.field_21466;
    }

    private boolean tryModifySpawnerBlock() {
        if (!this.stack.itematic$hasComponent(ItemComponentTypes.SPAWN_EGG)) {
            return false;
        }
        if (!this.blockState.method_27852(class_2246.field_10260)) {
            return false;
        }
        Optional optionalBlockEntity = this.world.method_35230(this.blockPos, class_2591.field_11889);
        if (optionalBlockEntity.isEmpty()) {
            return false;
        }
        this.modifySpawnerBlock((class_2636)optionalBlockEntity.get());
        this.tryDecrementStack();
        return true;
    }

    private void modifySpawnerBlock(class_2636 blockEntity) {
        blockEntity.method_46408(this.initializer.type(), this.world.method_8409());
        blockEntity.method_5431();
        this.world.method_8413(this.blockPos, this.blockState, this.blockState, 3);
        this.world.method_33596((class_1297)this.player, (class_6880)class_5712.field_28733, this.blockPos);
    }

    private void placeEntity() {
        class_1937 class_19372 = this.world;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        class_2338 offset = this.blockState.method_26220((class_1922)this.world, this.blockPos).method_1110() ? this.blockPos : this.blockPos.method_10093(this.direction);
        ActionContext context = ActionContext.builder(serverWorld, this.stack, this.resultStackConsumer, this.hand).entityPosition(ActionContextParameter.THIS, (class_1297)this.player).position(ActionContextParameter.TARGET, offset).side(this.direction).build();
        class_1297 entity = this.createEntity(offset, context);
        if (entity == null) {
            return;
        }
        if (this.spawnCallback != null) {
            this.spawnCallback.accept(entity, this.stack);
        }
        this.tryDecrementStack();
        this.world.method_33596((class_1297)this.player, (class_6880)class_5712.field_28738, entity.method_24515());
        this.stack.itematic$invokeEvent(ItemEvents.SPAWN_ENTITY, context.builderForCopy().entity(ActionContextParameter.TARGET, entity).build());
    }

    private class_1297 createEntity(class_2338 offset, ActionContext context) {
        if (this.world.method_8608()) {
            return null;
        }
        if (this.allowItemData) {
            this.initializer.type().itematic$setInitializer(this.initializer, context);
            class_1297 entity = this.initializer.type().method_5894((class_3218)this.world, this.stack, this.player, offset, this.spawnReason, true, !Objects.equals(this.blockPos, offset) && this.direction == class_2350.field_11036);
            this.initializer.type().itematic$setInitializer(null, null);
            return entity;
        }
        Object entity = this.initializer.create(context);
        if (entity != null) {
            entity.method_29495(class_243.method_24955((class_2382)offset));
            ((class_3218)this.world).method_30771(entity);
        }
        return entity;
    }
}

