/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.mixin.item;

import com.google.common.collect.Interner;
import java.util.List;
import java.util.Optional;
import net.errorcraft.itematic.access.item.ItemAccess;
import net.errorcraft.itematic.inventory.StackReferenceUtil;
import net.errorcraft.itematic.item.ItemBase;
import net.errorcraft.itematic.item.component.ItemComponent;
import net.errorcraft.itematic.item.component.ItemComponentSet;
import net.errorcraft.itematic.item.component.ItemComponentType;
import net.errorcraft.itematic.item.component.ItemComponentTypes;
import net.errorcraft.itematic.item.component.components.BlockItemComponent;
import net.errorcraft.itematic.item.component.components.DamageableItemComponent;
import net.errorcraft.itematic.item.component.components.EnchantableItemComponent;
import net.errorcraft.itematic.item.component.components.ItemHolderItemComponent;
import net.errorcraft.itematic.item.component.components.RecipeRemainderItemComponent;
import net.errorcraft.itematic.item.component.components.RepairableItemComponent;
import net.errorcraft.itematic.item.component.components.UseAnimationItemComponent;
import net.errorcraft.itematic.item.component.components.UseableItemComponent;
import net.errorcraft.itematic.item.event.ItemEvent;
import net.errorcraft.itematic.item.event.ItemEventMap;
import net.errorcraft.itematic.item.event.ItemEvents;
import net.errorcraft.itematic.mixin.item.ItemAccessor;
import net.errorcraft.itematic.world.action.context.ActionContext;
import net.errorcraft.itematic.world.action.context.parameter.ActionContextParameter;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.fabricmc.fabric.api.item.v1.FabricItem;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3544;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_6880;
import net.minecraft.class_9285;
import net.minecraft.class_9302;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1792.class})
public abstract class ItemExtender
implements ItemAccess,
FabricItem {
    @Shadow
    @Final
    @Mutable
    private class_9323 field_49263;
    @Unique
    private static final Interner<class_9323> COMPONENT_INTERNER = ItemAccessor.SettingsAccessor.componentInterner();
    @Unique
    private ItemBase base;
    @Unique
    private ItemComponentSet itemComponents;
    @Unique
    private ItemEventMap events;

    @Inject(method={"getMaxCount"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkStackableItemComponent(CallbackInfoReturnable<Integer> info) {
        if (!this.itematic$hasComponent(ItemComponentTypes.STACKABLE)) {
            info.setReturnValue((Object)1);
        }
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void useUseItemComponent(class_1937 world, class_1657 user, class_1268 hand, CallbackInfoReturnable<class_1271<class_1799>> info) {
        class_1799 stack = user.method_5998(hand);
        class_5630 stackReference = StackReferenceUtil.of(stack);
        class_1269 result = class_1269.field_5811;
        for (ItemComponent<?> component : this.itemComponents) {
            class_1269 newResult = component.use(world, user, hand, stack, arg_0 -> ((class_5630)stackReference).method_32332(arg_0));
            if (newResult == class_1269.field_5814) {
                info.setReturnValue((Object)class_1271.method_22431((Object)stackReference.method_32327()));
                return;
            }
            result = result.itematic$merge(newResult);
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            ActionContext context = ActionContext.builder(serverWorld, stack, arg_0 -> ((class_5630)stackReference).method_32332(arg_0), hand).entityPosition(ActionContextParameter.THIS, (class_1297)user).build();
            this.itematic$invokeEvent(ItemEvents.USE, context);
        }
        info.setReturnValue((Object)new class_1271(result, (Object)stackReference.method_32327()));
    }

    @Overwrite
    public class_1269 method_7884(class_1838 context) {
        Object component2;
        class_1799 stack = context.method_8041();
        class_5630 stackReference = StackReferenceUtil.of(stack);
        class_1269 result = class_1269.field_5811;
        for (Object component2 : this.itemComponents) {
            class_1269 newResult = component2.useOnBlock(context, arg_0 -> ((class_5630)stackReference).method_32332(arg_0));
            if (newResult == class_1269.field_5814) {
                return newResult;
            }
            result = result.itematic$merge(newResult);
        }
        component2 = context.method_8045();
        if (component2 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)component2;
            ActionContext actionContext = ActionContext.builder(serverWorld, stack, arg_0 -> ((class_5630)stackReference).method_32332(arg_0), context.method_20287()).entityPosition(ActionContextParameter.THIS, (class_1297)context.method_8036()).position(ActionContextParameter.TARGET, context.method_8037()).side(context.method_8038()).build();
            this.itematic$invokeEvent(ItemEvents.USE_ON_BLOCK, actionContext);
        }
        ItemExtender.tryUpdateItemStack((class_1309)context.method_8036(), context.method_20287(), stack, stackReference);
        return result;
    }

    @Overwrite
    public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        Object component2;
        class_5630 stackReference = StackReferenceUtil.of(stack);
        class_1269 result = class_1269.field_5811;
        for (Object component2 : this.itemComponents) {
            class_1269 newResult = component2.useOnEntity(user, entity, hand, stack, arg_0 -> ((class_5630)stackReference).method_32332(arg_0));
            if (newResult == class_1269.field_5814) {
                return newResult;
            }
            result = result.itematic$merge(newResult);
        }
        component2 = user.method_37908();
        if (component2 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)component2;
            ActionContext context = ActionContext.builder(serverWorld, stack, arg_0 -> ((class_5630)stackReference).method_32332(arg_0), hand).entityPosition(ActionContextParameter.THIS, (class_1297)user).entityPosition(ActionContextParameter.TARGET, (class_1297)entity).build();
            this.itematic$invokeEvent(ItemEvents.USE_ON_ENTITY, context);
        }
        ItemExtender.tryUpdateItemStack((class_1309)user, hand, stack, stackReference);
        return result;
    }

    @Overwrite
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        Object component2;
        boolean result = false;
        class_5630 stackReference = StackReferenceUtil.of(stack);
        for (Object component2 : this.itemComponents) {
            result |= component2.postHit(stack, target, attacker, arg_0 -> ((class_5630)stackReference).method_32332(arg_0));
        }
        component2 = attacker.method_37908();
        if (component2 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)component2;
            ActionContext context = ActionContext.builder(serverWorld, stack, arg_0 -> ((class_5630)stackReference).method_32332(arg_0), class_1304.field_6173).entityPosition(ActionContextParameter.THIS, (class_1297)attacker).entityPosition(ActionContextParameter.TARGET, (class_1297)target).build();
            this.itematic$invokeEvent(ItemEvents.HIT_ENTITY, context);
        }
        ItemExtender.tryUpdateItemStack(attacker, class_1268.field_5808, stack, stackReference);
        return result;
    }

    @Overwrite
    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        boolean result = false;
        class_5630 stackReference = StackReferenceUtil.of(stack);
        for (ItemComponent<?> component : this.itemComponents) {
            result |= component.postMine(stack, world, state, pos, miner, arg_0 -> ((class_5630)stackReference).method_32332(arg_0));
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            ActionContext context = ActionContext.builder(serverWorld, stack, arg_0 -> ((class_5630)stackReference).method_32332(arg_0), class_1304.field_6173).entityPosition(ActionContextParameter.THIS, (class_1297)miner).position(ActionContextParameter.TARGET, pos.method_46558()).build();
            this.itematic$invokeEvent(ItemEvents.BROKE_BLOCK, context);
        }
        ItemExtender.tryUpdateItemStack(miner, class_1268.field_5808, stack, stackReference);
        return result;
    }

    @Overwrite
    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        int usedTicks = user.itematic$itemUsedTicks();
        for (ItemComponent<?> component : this.itemComponents) {
            component.using(stack, world, user, usedTicks, remainingUseTicks);
        }
    }

    @Inject(method={"onItemEntityDestroyed"}, at={@At(value="HEAD")})
    private void onItemEntityDestroyedUseItemComponent(class_1542 entity, CallbackInfo info) {
        this.itematic$getComponent(ItemComponentTypes.BLOCK).ifPresent(c -> c.onDestroyed(entity));
        this.itematic$getComponent(ItemComponentTypes.ITEM_HOLDER).ifPresent(c -> c.onDestroyed(entity));
    }

    @Overwrite
    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        int usedTicks = user.itematic$itemUsedTicks();
        class_5630 stackReference = StackReferenceUtil.of(stack);
        for (ItemComponent<?> component : this.itemComponents) {
            component.stopUsing(stack, world, user, usedTicks, remainingUseTicks, arg_0 -> ((class_5630)stackReference).method_32332(arg_0));
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            ActionContext context = ActionContext.builder(serverWorld, stack, arg_0 -> ((class_5630)stackReference).method_32332(arg_0), user.method_6058()).entityPosition(ActionContextParameter.THIS, (class_1297)user).build();
            this.itematic$invokeEvent(ItemEvents.STOPPED_USING, context);
        }
        ItemExtender.tryUpdateItemStack(user, class_1268.field_5808, stack, stackReference);
    }

    @Inject(method={"finishUsing"}, at={@At(value="HEAD")}, cancellable=true)
    public void finishUsingUseItemComponent(class_1799 stack, class_1937 world, class_1309 user, CallbackInfoReturnable<class_1799> info) {
        int usedTicks = user.itematic$itemUsedTicks();
        class_5630 stackReference = StackReferenceUtil.of(stack);
        for (ItemComponent<?> component : this.itemComponents) {
            component.finishUsing(world, user, stack, usedTicks, arg_0 -> ((class_5630)stackReference).method_32332(arg_0));
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            ActionContext context = ActionContext.builder(serverWorld, stack, arg_0 -> ((class_5630)stackReference).method_32332(arg_0), user.method_6058()).entityPosition(ActionContextParameter.THIS, (class_1297)user).build();
            this.itematic$invokeEvent(ItemEvents.FINISHED_USING, context);
        }
        this.itematic$getComponent(ItemComponentTypes.CONSUMABLE).ifPresent(c -> c.consume(user, stack, arg_0 -> ((class_5630)stackReference).method_32332(arg_0), world, user.method_6058()));
        info.setReturnValue((Object)stackReference.method_32327());
    }

    @Overwrite
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        for (ItemComponent<?> component : this.itemComponents) {
            component.inventoryTick(stack, world, entity, slot, selected);
        }
    }

    @Overwrite
    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        boolean result = false;
        for (ItemComponent<?> component : this.itemComponents) {
            result |= component.clickOnSlot(stack, slot, clickType, player);
        }
        return result;
    }

    @Overwrite
    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        boolean result = false;
        for (ItemComponent<?> component : this.itemComponents) {
            result |= component.clickedOnWithStack(stack, otherStack, slot, clickType, player, arg_0 -> ((class_5630)cursorStackReference).method_32332(arg_0));
        }
        return result;
    }

    @Inject(method={"onCraft"}, at={@At(value="HEAD")})
    public void onCraft(class_1799 stack, class_1937 world, CallbackInfo info) {
        for (ItemComponent<?> component : this.itemComponents) {
            component.onCraft(stack, world);
        }
    }

    @Overwrite
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        this.base.tooltip().ifPresent(tooltip::addAll);
        for (ItemComponent<?> component : this.itemComponents) {
            component.appendTooltip(stack, context, tooltip, type);
        }
    }

    @Redirect(method={"isEnchantable"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;contains(Lnet/minecraft/component/DataComponentType;)Z"))
    public boolean isEnchantableUseComponentCheck(class_1799 instance, class_9331<?> type) {
        return instance.itematic$hasComponent(ItemComponentTypes.ENCHANTABLE);
    }

    @Inject(method={"canMine"}, at={@At(value="HEAD")}, cancellable=true)
    private void useDebugStickItemComponent(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner, CallbackInfoReturnable<Boolean> info) {
        this.itematic$getComponent(ItemComponentTypes.DEBUG_STICK).ifPresent(c -> {
            c.use(miner, state, (class_1936)world, pos);
            info.setReturnValue((Object)false);
        });
    }

    @Overwrite
    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return this.itematic$getComponent(ItemComponentTypes.REPAIRABLE).map(RepairableItemComponent::items).map(arg_0 -> ((class_1799)ingredient).method_31573(arg_0)).orElse(false);
    }

    @Inject(method={"hasGlint"}, at={@At(value="HEAD")}, cancellable=true)
    public void checkPointableItemComponent(class_1799 stack, CallbackInfoReturnable<Boolean> info) {
        if (this.itematic$hasComponent(ItemComponentTypes.POINTABLE) && stack.method_57826(class_9334.field_49614)) {
            info.setReturnValue((Object)true);
        }
    }

    @Overwrite
    public boolean method_7857() {
        return this.itematic$hasComponent(ItemComponentTypes.RECIPE_REMAINDER);
    }

    @Overwrite
    public boolean method_31568() {
        return this.itematic$getComponent(ItemComponentTypes.BLOCK).map(BlockItemComponent::canBeNested).orElse(true);
    }

    @Overwrite
    public int method_7837() {
        return this.itematic$getComponent(ItemComponentTypes.ENCHANTABLE).map(EnchantableItemComponent::enchantability).orElse(0);
    }

    @Overwrite
    public class_3414 method_57336() {
        return this.itematic$getComponent(ItemComponentTypes.DAMAGEABLE).flatMap(DamageableItemComponent::breakSound).map(class_6880::comp_349).orElse(class_3417.field_15075);
    }

    @Overwrite
    public boolean method_16698() {
        return this.itematic$hasComponent(ItemComponentTypes.MAP_HOLDER);
    }

    @Inject(method={"getUseAction"}, at={@At(value="HEAD")}, cancellable=true)
    public void getUseActionUseItemComponent(class_1799 stack, CallbackInfoReturnable<class_1839> info) {
        class_1839 animation = this.itematic$getComponent(ItemComponentTypes.USE_ANIMATION).map(UseAnimationItemComponent::animation).orElse(class_1839.field_8952);
        info.setReturnValue((Object)animation);
    }

    @Inject(method={"getMaxUseTime"}, at={@At(value="HEAD")}, cancellable=true)
    public void getMaxUseTimeUseItemComponent(class_1799 stack, CallbackInfoReturnable<Integer> info) {
        int maxUseTime = this.itematic$getComponent(ItemComponentTypes.USEABLE).map(UseableItemComponent::ticks).orElse(-1);
        info.setReturnValue((Object)maxUseTime);
    }

    @Inject(method={"getItemBarColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void itemBarColorUseItemComponentCheck(class_1799 stack, CallbackInfoReturnable<Integer> info) {
        if (this.itematic$hasComponent(ItemComponentTypes.ITEM_HOLDER)) {
            info.setReturnValue((Object)ItemHolderItemComponent.ITEM_BAR_COLOR);
        }
    }

    @Overwrite
    public String method_7876() {
        return this.base.translationKey();
    }

    @Overwrite
    public String method_7866(class_1799 stack) {
        return this.itematic$getComponent(ItemComponentTypes.POINTABLE).flatMap(c -> c.lodestoneTranslationKey(stack)).or(() -> this.itematic$getComponent(ItemComponentTypes.POTION_HOLDER).map(c -> c.translationKey(stack, this.method_7876()))).or(() -> this.itematic$getComponent(ItemComponentTypes.BANNER_PATTERN_HOLDER).flatMap(c -> c.translationKey(stack, this.method_7876()))).orElseGet(this::method_7876);
    }

    @Overwrite
    public Optional<class_5632> method_32346(class_1799 stack) {
        return this.itematic$getComponent(ItemComponentTypes.ITEM_HOLDER).flatMap(c -> c.tooltipData(stack));
    }

    @Inject(method={"isItemBarVisible"}, at={@At(value="HEAD")}, cancellable=true)
    private void isItemBarVisibleCheckItemHolderItemComponent(class_1799 stack, CallbackInfoReturnable<Boolean> info) {
        this.itematic$getComponent(ItemComponentTypes.ITEM_HOLDER).map(c -> c.itemBarVisible(stack)).ifPresent(arg_0 -> info.setReturnValue(arg_0));
    }

    @Inject(method={"getItemBarStep"}, at={@At(value="HEAD")}, cancellable=true)
    public void getItemBarStepCheckItemHolderItemComponent(class_1799 stack, CallbackInfoReturnable<Integer> info) {
        this.itematic$getComponent(ItemComponentTypes.ITEM_HOLDER).map(c -> c.itemBarStep(stack)).ifPresent(arg_0 -> info.setReturnValue(arg_0));
    }

    @Inject(method={"getName(Lnet/minecraft/item/ItemStack;)Lnet/minecraft/text/Text;"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkTextHolderItemComponent(class_1799 stack, CallbackInfoReturnable<class_2561> info) {
        if (!stack.itematic$hasComponent(ItemComponentTypes.TEXT_HOLDER)) {
            return;
        }
        class_9302 writtenBookContent = (class_9302)stack.method_57824(class_9334.field_49606);
        if (writtenBookContent == null) {
            return;
        }
        String title = (String)writtenBookContent.comp_2419().comp_2369();
        if (class_3544.method_57181((String)title)) {
            return;
        }
        info.setReturnValue((Object)class_2561.method_43470((String)title));
    }

    @Override
    public ItemBase itematic$itemBase() {
        return this.base;
    }

    @Override
    public void itematic$setItemBase(ItemBase base) {
        this.base = base;
    }

    @Override
    public ItemComponentSet itematic$components() {
        return this.itemComponents;
    }

    @Override
    public void itematic$setComponents(ItemComponentSet components) {
        this.itemComponents = components;
        this.field_49263 = this.initializeComponents();
    }

    @Override
    public <T extends ItemComponent<T>> boolean itematic$hasComponent(ItemComponentType<T> type) {
        if (this.itemComponents == null) {
            return false;
        }
        return this.itemComponents.contains(type);
    }

    @Override
    public <T extends ItemComponent<T>> Optional<T> itematic$getComponent(ItemComponentType<T> type) {
        if (this.itemComponents == null) {
            return Optional.empty();
        }
        return this.itemComponents.get(type);
    }

    @Override
    public ItemEventMap itematic$events() {
        return this.events;
    }

    @Override
    public void itematic$setEvents(ItemEventMap events) {
        this.events = events;
    }

    @Override
    public boolean itematic$invokeEvent(ItemEvent event, ActionContext context) {
        return this.events.invokeEvent(event, context);
    }

    @Override
    public boolean itematic$mayStartUsing(class_1937 world, class_1657 user, class_1268 hand, class_1799 stack) {
        return this.itematic$getComponent(ItemComponentTypes.FOOD).map(c -> c.mayStartUsing(user)).orElse(true);
    }

    public class_1799 getRecipeRemainder(class_1799 stack) {
        return this.itematic$getComponent(ItemComponentTypes.RECIPE_REMAINDER).map(RecipeRemainderItemComponent::item).map(class_1799::new).orElse(class_1799.field_8037);
    }

    public boolean canBeEnchantedWith(class_1799 stack, class_1887 enchantment, EnchantingContext context) {
        return true;
    }

    @Unique
    private static void tryUpdateItemStack(class_1309 target, class_1268 hand, class_1799 stack, class_5630 stackReference) {
        if (target == null) {
            return;
        }
        class_1799 newStack = stackReference.method_32327();
        if (stack == newStack) {
            return;
        }
        target.method_6122(hand, newStack);
    }

    @Unique
    private class_9323 initializeComponents() {
        class_9323.class_9324 componentsBuilder = class_9323.method_57827().method_57839(class_9334.field_49627);
        this.base.addComponents(componentsBuilder);
        class_9285.class_9286 attributeModifiersBuilder = class_9285.method_57480();
        for (ItemComponent<?> component : this.itemComponents) {
            component.addComponents(componentsBuilder);
            component.addAttributeModifiers(attributeModifiersBuilder, this.itemComponents);
        }
        class_9285 attributeModifiers = attributeModifiersBuilder.method_57486();
        if (!attributeModifiers.comp_2393().isEmpty()) {
            componentsBuilder.method_57840(class_9334.field_49636, (Object)attributeModifiers);
        }
        return (class_9323)COMPONENT_INTERNER.intern((Object)componentsBuilder.method_57838());
    }
}

