/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.serialization;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.errorcraft.itematic.mixin.util.dynamic.CodecsAccessor;

public class ItematicCodecs {
    public static final Codec<Float> NON_NEGATIVE_FLOAT = Codec.FLOAT.validate(value -> {
        if (value.floatValue() >= 0.0f && value.floatValue() <= Float.MAX_VALUE) {
            return DataResult.success((Object)value);
        }
        return DataResult.error(() -> "Value must be non-negative: " + value);
    });
    public static final Codec<Double> NON_NEGATIVE_DOUBLE = Codec.DOUBLE.validate(value -> {
        if (value >= 0.0 && value <= Double.MAX_VALUE) {
            return DataResult.success((Object)value);
        }
        return DataResult.error(() -> "Value must be non-negative: " + value);
    });

    private ItematicCodecs() {
    }

    public static Codec<Integer> index(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("size must be positive: " + size);
        }
        return Codec.INT.validate(i -> {
            if (i >= 0 && i <= size) {
                return DataResult.success((Object)i);
            }
            return DataResult.error(() -> "Index must be non-negative and less than " + size + ": " + i);
        });
    }

    public static <T> Codec<Set<T>> setCodec(Codec<T> codec) {
        return new SetCodec<T>(codec);
    }

    public static Codec<Float> positiveFloat(float maxInclusive) {
        if (maxInclusive <= 0.0f) {
            throw new IllegalArgumentException("maxInclusive must be positive, got " + maxInclusive + " instead");
        }
        return CodecsAccessor.rangedFloat(0.0f, maxInclusive, value -> "Value must be positive and at most " + maxInclusive + ": " + value);
    }

    private static class SetCodec<E>
    implements Codec<Set<E>> {
        private final Codec<List<E>> listCodec;

        private SetCodec(Codec<E> codec) {
            this.listCodec = codec.listOf();
        }

        public <T> DataResult<Pair<Set<E>, T>> decode(DynamicOps<T> ops, T input) {
            return this.listCodec.decode(ops, input).flatMap(pair -> {
                List elements = (List)pair.getFirst();
                HashSet set = new HashSet();
                HashSet duplicates = new HashSet();
                for (Object element : elements) {
                    if (set.add(element)) continue;
                    duplicates.add(element);
                }
                if (!duplicates.isEmpty()) {
                    return DataResult.error(() -> "Set contained duplicate entries: " + duplicates.stream().map(Object::toString).collect(Collectors.joining(", ")));
                }
                return DataResult.success((Object)Pair.of(set, (Object)pair.getSecond()));
            });
        }

        public <T> DataResult<T> encode(Set<E> input, DynamicOps<T> ops, T prefix) {
            return this.listCodec.encode(new ArrayList<E>(input), ops, prefix);
        }
    }
}

