/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.world.action;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.errorcraft.itematic.registry.ItematicRegistryKeys;
import net.errorcraft.itematic.world.action.Action;
import net.errorcraft.itematic.world.action.ActionRequirements;
import net.errorcraft.itematic.world.action.actions.SequenceAction;
import net.errorcraft.itematic.world.action.context.ActionContext;
import net.errorcraft.itematic.world.action.sequence.handler.SequenceHandler;
import net.minecraft.class_5381;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;

public record ActionEntry(Action<?> action, Optional<ActionRequirements> requirements) {
    public static final Codec<ActionEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Action.CODEC.fieldOf("action").forGetter(ActionEntry::action), (App)ActionRequirements.CODEC.optionalFieldOf("requirements").forGetter(ActionEntry::requirements)).apply((Applicative)instance, ActionEntry::new));
    public static final Codec<class_6880<ActionEntry>> REGISTRY_CODEC = class_5381.method_29749(ItematicRegistryKeys.ACTION, CODEC);
    public static final Codec<class_6885<ActionEntry>> REGISTRY_ENTRY_LIST_CODEC = class_6895.method_40343(ItematicRegistryKeys.ACTION, CODEC, (boolean)true);

    public Optional<Boolean> execute(ActionContext context) {
        if (!this.test(context)) {
            return Optional.empty();
        }
        return Optional.of(this.action.execute(context));
    }

    private boolean test(ActionContext context) {
        return this.requirements.map(requirements -> requirements.test(context)).orElse(true);
    }

    public static ActionEntry of(Action<?> action) {
        return new ActionEntry(action, Optional.empty());
    }

    public static ActionEntry of(SequenceHandler.Builder<?, ?> builder) {
        return new ActionEntry(SequenceAction.of(builder), Optional.empty());
    }

    public static ActionEntry of(ActionRequirements requirements, Action<?> action) {
        return new ActionEntry(action, Optional.of(requirements));
    }

    public static ActionEntry of(ActionRequirements requirements, SequenceHandler.Builder<?, ?> builder) {
        return new ActionEntry(SequenceAction.of(builder), Optional.of(requirements));
    }
}

