/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.world.action.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import net.errorcraft.itematic.block.BlockStateUtil;
import net.errorcraft.itematic.world.action.Action;
import net.errorcraft.itematic.world.action.ActionType;
import net.errorcraft.itematic.world.action.ActionTypes;
import net.errorcraft.itematic.world.action.context.ActionContext;
import net.errorcraft.itematic.world.action.context.parameter.ActionContextParameter;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3218;

public record ModifyBlockStateAction(ActionContextParameter position, Map<String, String> properties, boolean pushEntitiesUpwards) implements Action<ModifyBlockStateAction>
{
    public static final MapCodec<ModifyBlockStateAction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ActionContextParameter.CODEC.fieldOf("position").forGetter(ModifyBlockStateAction::position), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).fieldOf("properties").forGetter(ModifyBlockStateAction::properties), (App)Codec.BOOL.optionalFieldOf("push_entities_upwards", (Object)false).forGetter(ModifyBlockStateAction::pushEntitiesUpwards)).apply((Applicative)instance, ModifyBlockStateAction::new));

    public static Builder builder(ActionContextParameter position) {
        return new Builder(position);
    }

    @Override
    public ActionType<ModifyBlockStateAction> type() {
        return ActionTypes.MODIFY_BLOCK_STATE;
    }

    @Override
    public boolean execute(ActionContext context) {
        class_2680 state;
        class_3218 world = context.world();
        class_2338 pos = context.blockPos(this.position);
        class_2680 newState = state = world.method_8320(pos);
        class_2689 stateManager = state.method_26204().method_9595();
        for (String key : this.properties.keySet()) {
            class_2769 property = stateManager.method_11663(key);
            if (property == null) continue;
            newState = BlockStateUtil.with(newState, property, this.properties.get(key));
        }
        if (state == newState) {
            return false;
        }
        if (this.pushEntitiesUpwards) {
            class_2248.method_9582((class_2680)state, (class_2680)newState, (class_1936)world, (class_2338)pos);
        }
        world.method_8501(pos, newState);
        return true;
    }

    public static final class Builder {
        private final ActionContextParameter position;
        private final Map<String, String> properties = new HashMap<String, String>();
        private boolean pushEntitiesUpwards = false;

        private Builder(ActionContextParameter position) {
            this.position = position;
        }

        public ModifyBlockStateAction build() {
            return new ModifyBlockStateAction(this.position, this.properties, this.pushEntitiesUpwards);
        }

        public <T extends Comparable<T>> Builder property(class_2769<T> property, T value) {
            this.properties.put(property.method_11899(), property.method_11901(value));
            return this;
        }

        public Builder pushEntitiesUpwards() {
            this.pushEntitiesUpwards = true;
            return this;
        }
    }
}

