/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.world.action.actions;

import com.mojang.serialization.MapCodec;
import net.errorcraft.itematic.network.packet.s2c.play.TwirlS2CPacket;
import net.errorcraft.itematic.world.action.Action;
import net.errorcraft.itematic.world.action.ActionType;
import net.errorcraft.itematic.world.action.ActionTypes;
import net.errorcraft.itematic.world.action.context.ActionContext;
import net.errorcraft.itematic.world.action.context.parameter.ActionContextParameter;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public record TwirlPlayerAction() implements Action<TwirlPlayerAction>
{
    public static final TwirlPlayerAction INSTANCE = new TwirlPlayerAction();
    public static final MapCodec<TwirlPlayerAction> CODEC = MapCodec.unit((Object)INSTANCE);

    @Override
    public ActionType<TwirlPlayerAction> type() {
        return ActionTypes.TWIRL_PLAYER;
    }

    @Override
    public boolean execute(ActionContext context) {
        class_1657 player = context.player(ActionContextParameter.THIS).orElse(null);
        if (player == null) {
            return false;
        }
        int riptideLevel = class_1890.method_8202((class_1799)context.stack());
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            serverPlayer.field_13987.method_14364((class_2596)new TwirlS2CPacket(riptideLevel));
        }
        TwirlPlayerAction.execute(riptideLevel, player, (class_1937)context.world());
        return true;
    }

    public static void execute(int riptideLevel, class_1657 player, class_1937 world) {
        double riptideFactor = 3.0 * ((1.0 + (double)riptideLevel) / 4.0);
        float yaw = player.method_36454();
        float pitch = player.method_36455();
        double x = -Math.sin((double)yaw * (Math.PI / 180)) * Math.cos((double)pitch * (Math.PI / 180));
        double y = -Math.sin((double)pitch * (Math.PI / 180));
        double z = Math.cos((double)yaw * (Math.PI / 180)) * Math.cos((double)pitch * (Math.PI / 180));
        double distance = Math.sqrt(x * x + y * y + z * z);
        player.method_5762(x * riptideFactor / distance, y * riptideFactor / distance, z * riptideFactor / distance);
        player.method_40126(20);
        if (player.method_24828()) {
            player.method_5784(class_1313.field_6308, new class_243(0.0, 1.2, 0.0));
        }
        world.method_43129(null, (class_1297)player, TwirlPlayerAction.soundEvent(riptideLevel), class_3419.field_15248, 1.0f, 1.0f);
    }

    private static class_3414 soundEvent(int level) {
        if (level >= 3) {
            return class_3417.field_14717;
        }
        if (level == 2) {
            return class_3417.field_14806;
        }
        return class_3417.field_14606;
    }
}

