/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.item.component.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.errorcraft.itematic.entity.initializer.EntityInitializer;
import net.errorcraft.itematic.entity.initializer.initializers.SimpleEntityInitializer;
import net.errorcraft.itematic.item.ItemStackConsumer;
import net.errorcraft.itematic.item.component.ItemComponent;
import net.errorcraft.itematic.item.component.ItemComponentType;
import net.errorcraft.itematic.item.component.ItemComponentTypes;
import net.errorcraft.itematic.item.component.components.DispensableItemComponent;
import net.errorcraft.itematic.item.dispense.behavior.DispenseBehavior;
import net.errorcraft.itematic.item.dispense.behavior.DispenseBehaviors;
import net.errorcraft.itematic.item.placement.EntityPlacer;
import net.errorcraft.itematic.mixin.item.DecorationItemAccessor;
import net.errorcraft.itematic.mixin.item.SpawnEggItemAccessor;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1534;
import net.minecraft.class_1535;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public record EntityItemComponent(EntityInitializer<?> entity, boolean allowItemData) implements ItemComponent<EntityItemComponent>
{
    public static final Codec<EntityItemComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityInitializer.CODEC.fieldOf("entity").forGetter(EntityItemComponent::entity), (App)Codec.BOOL.optionalFieldOf("allow_item_data", (Object)false).forGetter(EntityItemComponent::allowItemData)).apply((Applicative)instance, EntityItemComponent::new));
    private static final MapCodec<class_1299<?>> ENTITY_TYPE_MAP_CODEC = SpawnEggItemAccessor.entityTypeMapCodec();
    private static final class_2561 RANDOM_TEXT = DecorationItemAccessor.randomText();

    @Override
    public ItemComponentType<EntityItemComponent> type() {
        return ItemComponentTypes.ENTITY;
    }

    @Override
    public Codec<EntityItemComponent> codec() {
        return CODEC;
    }

    @Override
    public void appendTooltip(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        if (this.entity.type() != class_1299.field_6120) {
            return;
        }
        class_9279 entityData = (class_9279)stack.method_57825(class_9334.field_49609, (Object)class_9279.field_49302);
        if (!entityData.method_57458()) {
            entityData.method_57446((MapDecoder)class_1534.field_49238).result().ifPresentOrElse(variant -> {
                variant.method_40230().ifPresent(key -> {
                    tooltip.add((class_2561)class_2561.method_43471((String)key.method_29177().method_48747("painting", "title")).method_27692(class_124.field_1054));
                    tooltip.add((class_2561)class_2561.method_43471((String)key.method_29177().method_48747("painting", "author")).method_27692(class_124.field_1080));
                });
                tooltip.add((class_2561)class_2561.method_43469((String)"painting.dimensions", (Object[])new Object[]{class_3532.method_38788((int)((class_1535)variant.comp_349()).method_6945(), (int)16), class_3532.method_38788((int)((class_1535)variant.comp_349()).method_6943(), (int)16)}));
            }, () -> tooltip.add(RANDOM_TEXT));
            return;
        }
        if (type.method_47370()) {
            tooltip.add(RANDOM_TEXT);
        }
    }

    public static EntityItemComponent of(EntityInitializer<?> entity) {
        return EntityItemComponent.of(entity, false);
    }

    public static EntityItemComponent of(EntityInitializer<?> entity, boolean allowItemData) {
        return new EntityItemComponent(entity, allowItemData);
    }

    public static ItemComponent<?>[] from(EntityInitializer<?> entity, class_7871<DispenseBehavior> dispenseBehaviors) {
        return EntityItemComponent.from(entity, false, dispenseBehaviors);
    }

    public static ItemComponent<?>[] from(EntityInitializer<?> entity, boolean allowItemData, class_7871<DispenseBehavior> dispenseBehaviors) {
        return new ItemComponent[]{EntityItemComponent.of(entity, allowItemData), DispensableItemComponent.of((class_6880<DispenseBehavior>)dispenseBehaviors.method_46747(DispenseBehaviors.SPAWN_ENTITY_FROM_ITEM))};
    }

    @Override
    public class_1269 useOnBlock(class_1838 context, ItemStackConsumer resultStackConsumer) {
        class_1799 stack = context.method_8041();
        if (context.method_8045().method_8608()) {
            return class_1269.field_5812;
        }
        EntityPlacer placer = EntityPlacer.spawned(context, stack, resultStackConsumer, this);
        return placer.place();
    }

    public EntityInitializer<?> getEntityInitializer(class_1799 stack) {
        if (!this.allowItemData) {
            return this.entity;
        }
        class_9279 entityData = (class_9279)stack.method_57825(class_9334.field_49609, (Object)class_9279.field_49302);
        Optional<EntityInitializer> initializer = entityData.method_57446(ENTITY_TYPE_MAP_CODEC).result().map(SimpleEntityInitializer::new);
        return initializer.orElse(this.entity);
    }
}

