/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.item.component.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.errorcraft.itematic.item.ItemStackConsumer;
import net.errorcraft.itematic.item.component.ItemComponent;
import net.errorcraft.itematic.item.component.ItemComponentType;
import net.errorcraft.itematic.item.component.ItemComponentTypes;
import net.errorcraft.itematic.item.component.components.UseableItemComponent;
import net.errorcraft.itematic.item.event.ItemEvents;
import net.errorcraft.itematic.item.use.provider.providers.TridentIntegerProvider;
import net.errorcraft.itematic.serialization.ItematicCodecs;
import net.errorcraft.itematic.world.action.context.ActionContext;
import net.errorcraft.itematic.world.action.context.parameter.ActionContextParameter;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2096;
import net.minecraft.class_3218;
import net.minecraft.class_3468;

public record ThrowableItemComponent(float speed, float angleOffset, Optional<class_2096.class_2100> drawDuration) implements ItemComponent<ThrowableItemComponent>
{
    public static final Codec<ThrowableItemComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItematicCodecs.NON_NEGATIVE_FLOAT.fieldOf("speed").forGetter(ThrowableItemComponent::speed), (App)Codec.FLOAT.fieldOf("angle_offset").forGetter(ThrowableItemComponent::angleOffset), (App)class_2096.class_2100.field_45763.optionalFieldOf("draw_duration").forGetter(ThrowableItemComponent::drawDuration)).apply((Applicative)instance, ThrowableItemComponent::new));

    public static ThrowableItemComponent of() {
        return new ThrowableItemComponent(0.0f, 0.0f, Optional.empty());
    }

    public static ThrowableItemComponent of(float speed) {
        return new ThrowableItemComponent(speed, 0.0f, Optional.empty());
    }

    public static ThrowableItemComponent of(float speed, float angleOffset) {
        return new ThrowableItemComponent(speed, angleOffset, Optional.empty());
    }

    public static ItemComponent<?>[] trident(float speed, float angleOffset, int minDrawDuration) {
        return new ItemComponent[]{UseableItemComponent.builder().ticks(TridentIntegerProvider.INSTANCE).animation(class_1839.field_8951).build(), new ThrowableItemComponent(speed, angleOffset, Optional.of(class_2096.class_2100.method_9053((int)minDrawDuration)))};
    }

    @Override
    public ItemComponentType<ThrowableItemComponent> type() {
        return ItemComponentTypes.THROWABLE;
    }

    @Override
    public Codec<ThrowableItemComponent> codec() {
        return CODEC;
    }

    @Override
    public class_1269 use(class_1937 world, class_1657 user, class_1268 hand, class_1799 stack, ItemStackConsumer resultStackConsumer) {
        if (this.drawDuration.isPresent()) {
            return class_1269.field_5811;
        }
        return this.createEntity(world, (class_1309)user, stack, resultStackConsumer);
    }

    @Override
    public void stopUsing(class_1799 stack, class_1937 world, class_1309 user, int usedTicks, int remainingUseTicks, ItemStackConsumer resultStackConsumer) {
        if (this.drawDuration.filter(drawDuration -> drawDuration.method_9054(usedTicks)).isPresent()) {
            this.createEntity(world, user, stack, resultStackConsumer);
            if (user instanceof class_1657) {
                class_1657 player = (class_1657)user;
                player.method_7259(class_3468.field_15372.itematic$getOrCreateStat(stack.method_41409()));
            }
        }
    }

    private class_1269 createEntity(class_1937 world, class_1309 user, class_1799 stack, ItemStackConsumer resultStackConsumer) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            ActionContext context = ActionContext.builder(serverWorld, stack, resultStackConsumer).entityPosition(ActionContextParameter.THIS, (class_1297)user).position(ActionContextParameter.TARGET, user.method_33571().method_1031(0.0, -0.1, 0.0)).build();
            this.createEntity(context);
        }
        return class_1269.method_29236((boolean)world.method_8608());
    }

    private void createEntity(ActionContext context) {
        context.stack().itematic$getComponent(ItemComponentTypes.PROJECTILE).map(c -> c.createEntity(context, ActionContextParameter.TARGET, this.angleOffset, this.speed, 1.0f)).ifPresent(projectile -> {
            context.world().method_8649(projectile);
            ActionContext projectileContext = context.builderForCopy().entityPosition(ActionContextParameter.TARGET, (class_1297)projectile).build();
            context.stack().itematic$invokeEvent(ItemEvents.THROW_PROJECTILE, projectileContext);
        });
    }
}

