/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.item.group.entry;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.function.Function;
import net.errorcraft.itematic.item.group.entry.ItemGroupEntryType;
import net.errorcraft.itematic.item.group.entry.entries.StackItemGroupEntry;
import net.errorcraft.itematic.item.group.entry.entries.TagItemGroupEntry;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3542;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6899;
import net.minecraft.class_7924;
import net.minecraft.class_9326;

public abstract class ItemGroupEntry {
    public static final Codec<ItemGroupEntry> ENTRY_CODEC = class_3542.method_28140(ItemGroupEntryType::values).dispatch(ItemGroupEntry::type, ItemGroupEntryType::codec);
    public static final Codec<ItemGroupEntry> CODEC = Codec.either((Codec)class_6899.method_40400((class_5321)class_7924.field_41197), ENTRY_CODEC).xmap(either -> (ItemGroupEntry)either.map(StackItemGroupEntry::new, Function.identity()), ItemGroupEntry::createEither);
    private final class_1761.class_7705 visibility;
    private final boolean requiresPermissions;

    protected ItemGroupEntry(class_1761.class_7705 visibility, boolean requiresPermissions) {
        this.visibility = visibility;
        this.requiresPermissions = requiresPermissions;
    }

    protected ItemGroupEntry() {
        this(class_1761.class_7705.field_40191, false);
    }

    protected class_1761.class_7705 visibility() {
        return this.visibility;
    }

    protected boolean requiresPermissions() {
        return this.requiresPermissions;
    }

    protected abstract Collection<class_1799> createStacks(class_1761.class_8128 var1);

    protected abstract ItemGroupEntryType type();

    public final void addStacks(class_1761.class_8128 context, class_1761.class_7704 entries) {
        if (this.requiresPermissions && !context.comp_1252()) {
            return;
        }
        entries.method_45424(this.createStacks(context), this.visibility);
    }

    protected Either<class_6880<class_1792>, ItemGroupEntry> createEither() {
        return Either.right((Object)this);
    }

    public static ItemGroupEntry simple(class_6880<class_1792> item) {
        return new StackItemGroupEntry(item);
    }

    public static ItemGroupEntry requiresPermissions(class_6880<class_1792> item) {
        return new StackItemGroupEntry(class_1761.class_7705.field_40191, true, item, class_9326.field_49588);
    }

    public static ItemGroupEntry tag(class_6862<class_1792> tag) {
        return new TagItemGroupEntry(tag);
    }

    protected static <T extends ItemGroupEntry> Products.P2<RecordCodecBuilder.Mu<T>, class_1761.class_7705, Boolean> createCodec(RecordCodecBuilder.Instance<T> instance) {
        return instance.group((App)class_3542.method_28140(class_1761.class_7705::values).optionalFieldOf("visibility", (Object)class_1761.class_7705.field_40191).forGetter(ItemGroupEntry::visibility), (App)Codec.BOOL.optionalFieldOf("requires_permissions", (Object)false).forGetter(ItemGroupEntry::requiresPermissions));
    }
}

