/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.item.group.entry.entries;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import net.errorcraft.itematic.item.group.entry.ItemGroupEntry;
import net.errorcraft.itematic.item.group.entry.ItemGroupEntryType;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6899;
import net.minecraft.class_7924;
import net.minecraft.class_9326;

public final class StackItemGroupEntry
extends ItemGroupEntry {
    public static final MapCodec<StackItemGroupEntry> CODEC = RecordCodecBuilder.mapCodec(instance -> StackItemGroupEntry.createCodec(instance).and(instance.group((App)class_6899.method_40400((class_5321)class_7924.field_41197).fieldOf("item").forGetter(StackItemGroupEntry::item), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(StackItemGroupEntry::components))).apply((Applicative)instance, StackItemGroupEntry::new));
    private final class_6880<class_1792> item;
    private final class_9326 components;

    public StackItemGroupEntry(class_6880<class_1792> item) {
        this(item, class_9326.field_49588);
    }

    public StackItemGroupEntry(class_6880<class_1792> item, class_9326 components) {
        this.item = item;
        this.components = components;
    }

    public StackItemGroupEntry(class_1761.class_7705 visibility, boolean requiresPermissions, class_6880<class_1792> item, class_9326 components) {
        super(visibility, requiresPermissions);
        this.item = item;
        this.components = components;
    }

    public static Builder builder(class_6880<class_1792> item) {
        return new Builder(item);
    }

    private class_6880<class_1792> item() {
        return this.item;
    }

    private class_9326 components() {
        return this.components;
    }

    @Override
    protected Collection<class_1799> createStacks(class_1761.class_8128 context) {
        return List.of(new class_1799(this.item, 1, this.components));
    }

    @Override
    protected ItemGroupEntryType type() {
        return ItemGroupEntryType.STACK;
    }

    @Override
    protected Either<class_6880<class_1792>, ItemGroupEntry> createEither() {
        if (this.isSimple()) {
            return Either.left(this.item);
        }
        return super.createEither();
    }

    public static ItemGroupEntry fromStack(class_1799 stack) {
        return new StackItemGroupEntry((class_6880<class_1792>)stack.method_41409(), stack.method_57380());
    }

    public static ItemGroupEntry fromStack(class_1799 stack, boolean requiresPermissions) {
        return new StackItemGroupEntry(class_1761.class_7705.field_40191, requiresPermissions, (class_6880<class_1792>)stack.method_41409(), stack.method_57380());
    }

    private boolean isSimple() {
        return this.visibility() == class_1761.class_7705.field_40191 && !this.requiresPermissions() && this.components.method_57848();
    }

    public static class Builder {
        private final class_6880<class_1792> item;
        private class_9326 components;
        private class_1761.class_7705 visibility = class_1761.class_7705.field_40191;
        private boolean requiresPermissions = false;

        public Builder(class_6880<class_1792> item) {
            this.item = item;
        }

        public StackItemGroupEntry build() {
            return new StackItemGroupEntry(this.visibility, this.requiresPermissions, this.item, this.components == null ? class_9326.field_49588 : this.components);
        }

        public Builder components(class_9326.class_9327 builder) {
            this.components = builder.method_57852();
            return this;
        }

        public Builder visibility(class_1761.class_7705 visibility) {
            this.visibility = visibility;
            return this;
        }

        public Builder requiresPermissions() {
            this.requiresPermissions = true;
            return this;
        }
    }
}

