/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.serialization;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_5321;

public class SetMapCodec<K, V>
extends MapCodec<Set<V>> {
    private final Codec<K> keyCodec;
    private final Function<K, ? extends Decoder<? extends V>> decoder;
    private final Function<V, ? extends Encoder<V>> encoder;
    private final Function<V, K> type;
    private final Function<K, String> keyToName;
    private final Keyable keys;

    public SetMapCodec(Codec<K> keyCodec, Function<K, Decoder<? extends V>> decoder, Function<V, ? extends Encoder<V>> encoder, Function<V, K> type, Function<K, String> keyToName, Keyable keys) {
        this.keyCodec = keyCodec;
        this.decoder = decoder;
        this.encoder = encoder;
        this.type = type;
        this.keyToName = keyToName;
        this.keys = keys;
    }

    public static <K, V> SetMapCodec<K, V> ofRegistry(class_2378<K> registry, Function<K, Codec<? extends V>> keyToCodec, Function<V, Codec<? extends V>> entryToCodec, Function<V, K> valueToKey) {
        return new SetMapCodec<Object, Object>((Codec<Object>)registry.method_39673(), (Function<Object, Decoder<Object>>)((Function<Object, Decoder>)keyToCodec::apply), (Function<Object, Encoder<Object>>)((Function<Object, Encoder>)v -> (Encoder)entryToCodec.apply(v)), (Function<Object, Object>)valueToKey, k -> ((class_5321)registry.method_29113(k).orElseThrow()).toString(), (Keyable)registry);
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return this.keys.keys(ops);
    }

    public <T> DataResult<Set<V>> decode(DynamicOps<T> ops, MapLike<T> input) {
        ImmutableSet.Builder read = ImmutableSet.builder();
        ImmutableList.Builder failed = ImmutableList.builder();
        HashSet keys = new HashSet();
        DataResult result = input.entries().reduce(DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.stable()), (r, pair) -> {
            DataResult valueResult = this.keyCodec.decode(ops, pair.getFirst()).flatMap(type -> {
                if (!keys.add(type.getFirst())) {
                    return DataResult.error(this.duplicateKey(type.getFirst()));
                }
                Decoder<? extends V> entryDecoder = this.decoder.apply(type.getFirst());
                return entryDecoder.decode(ops, pair.getSecond()).map(Pair::getFirst);
            });
            valueResult.error().ifPresent(e -> failed.add(pair));
            return r.apply2stable((u, v) -> {
                read.add(v);
                return u;
            }, valueResult);
        }, (r1, r2) -> r1.apply2stable((u1, u2) -> u1, r2));
        ImmutableSet elements = read.build();
        Object errors = ops.createMap(failed.build().stream());
        return result.map(arg_0 -> SetMapCodec.lambda$decode$8((Set)elements, arg_0)).setPartial((Object)elements).mapError(e -> e + ": " + String.valueOf(errors));
    }

    public <T> RecordBuilder<T> encode(Set<V> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        HashSet<K> keys = new HashSet<K>();
        for (V value : input) {
            Encoder<V> elementEncoder = this.encoder.apply(value);
            DataResult result = elementEncoder.encodeStart(ops, value);
            K key = this.type.apply(value);
            if (!keys.add(key)) {
                prefix.add(DataResult.error(this.duplicateKey(key)), result);
                continue;
            }
            DataResult resultKey = this.keyCodec.encodeStart(ops, key).setLifecycle(Lifecycle.stable());
            prefix.add(resultKey, result);
        }
        return prefix;
    }

    private Supplier<String> duplicateKey(K key) {
        return () -> "Duplicate key " + this.keyToName.apply(key) + " in set";
    }

    private static /* synthetic */ Set lambda$decode$8(Set elements, Unit unit) {
        return elements;
    }
}

