/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.village.trade;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.errorcraft.itematic.item.ItemKeys;
import net.errorcraft.itematic.mixin.village.TradeOffersAccessor;
import net.errorcraft.itematic.serialization.ItematicCodecs;
import net.errorcraft.itematic.util.Range;
import net.errorcraft.itematic.village.trade.modifier.TradeModifier;
import net.minecraft.class_117;
import net.minecraft.class_131;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_6899;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_9306;
import net.minecraft.class_9323;
import net.minecraft.class_9329;

public record Trade(List<Entry> wants, Entry gives, int maxUses, int tradeExperience, float priceMultiplier, Optional<TradeModifier<?>> tradeModifier) {
    public static final Codec<Trade> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Entry.CODEC.listOf(1, 2).fieldOf("wants").forGetter(Trade::wants), (App)Entry.CODEC.fieldOf("gives").forGetter(Trade::gives), (App)class_5699.field_33442.fieldOf("max_uses").forGetter(Trade::maxUses), (App)Codec.INT.optionalFieldOf("trade_experience", (Object)1).forGetter(Trade::tradeExperience), (App)Codec.FLOAT.optionalFieldOf("price_multiplier", (Object)Float.valueOf(0.0f)).forGetter(Trade::priceMultiplier), (App)TradeModifier.CODEC.optionalFieldOf("trade_modifier").forGetter(Trade::tradeModifier)).apply((Applicative)instance, Trade::new));
    public static final Codec<Integer> WANTED_INDEX_CODEC = ItematicCodecs.index(2);
    private static final int MAX_WANTED_ENTRIES = 2;

    public class_1914 createTradeOffer(class_47 context) {
        Input wants = this.createWantedStacks(context);
        class_9306 gives = this.createGivenStack(wants, context);
        return new class_1914(wants.getTradedItem(0).orElseThrow(), wants.getTradedItem(1), gives.comp_2427(), this.maxUses, this.tradeExperience, this.priceMultiplier);
    }

    private Input createWantedStacks(class_47 context) {
        List<class_1799> stacks = this.wants.stream().map(entry -> entry.createStack(context)).toList();
        return new Input(stacks);
    }

    private class_9306 createGivenStack(Input wants, class_47 context) {
        class_1799 gives = this.gives.createStack(context);
        return this.tradeModifier.flatMap(tradeModifier -> tradeModifier.apply(wants, gives, context)).orElseGet(() -> new class_9306(gives.method_41409(), gives.method_7947(), class_9329.method_57865((class_9323)gives.method_57353())));
    }

    public static Builder builder(Entry gives) {
        return new Builder(gives);
    }

    public static Trade of(Entry firstBuy, Entry sell, int maxUses, int tradeExperience) {
        return Trade.of(firstBuy, sell, maxUses, tradeExperience, 0.05f);
    }

    public static Trade of(Entry firstBuy, Entry sell, int maxUses, int tradeExperience, float priceMultiplier) {
        return Trade.of(List.of(firstBuy), sell, maxUses, tradeExperience, priceMultiplier, null);
    }

    public static Trade of(List<Entry> wants, Entry gives, int maxUses, int tradeExperience, float priceMultiplier, TradeModifier<?> tradeModifier) {
        if (wants.size() > 2) {
            throw new IllegalArgumentException("Wanted entries must not be more than 2");
        }
        return new Trade(wants, gives, maxUses, tradeExperience, priceMultiplier, Optional.ofNullable(tradeModifier));
    }

    public record Entry(class_6880<class_1792> item, Range.IntegerRange count, Optional<class_117> itemModifier) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6899.method_40400((class_5321)class_7924.field_41197).fieldOf("item").forGetter(Entry::item), (App)Range.INT_CODEC.optionalFieldOf("count", (Object)Range.IntegerRange.of(1)).forGetter(Entry::count), (App)class_131.field_50023.optionalFieldOf("item_modifier").forGetter(Entry::itemModifier)).apply((Applicative)instance, Entry::new));

        public class_1799 createStack(class_47 context) {
            int count = Math.clamp((long)this.count.get(context.method_294()).intValue(), 1, ((class_1792)this.item.comp_349()).method_7882());
            class_1799 stack = new class_1799(this.item, count);
            return this.itemModifier.map(itemModifier -> {
                context.method_298(class_47.method_51186((class_117)itemModifier));
                return (class_1799)itemModifier.apply((Object)stack, (Object)context);
            }).orElse(stack);
        }

        public static Entry of(class_6880<class_1792> item) {
            return Entry.of(item, 1, null);
        }

        public static Entry of(class_6880<class_1792> item, int count) {
            return Entry.of(item, count, null);
        }

        public static Entry of(class_6880<class_1792> item, int count, class_117 itemModifier) {
            return new Entry(item, Range.IntegerRange.of(count), Optional.ofNullable(itemModifier));
        }

        public static Entry ofEmerald(class_7871<class_1792> items) {
            return Entry.ofEmerald(items, 1);
        }

        public static Entry ofEmerald(class_7871<class_1792> items, int count) {
            return Entry.of((class_6880<class_1792>)items.method_46747(ItemKeys.EMERALD), count);
        }
    }

    public static class Input {
        private final List<class_1799> stacks;

        private Input(List<class_1799> stacks) {
            this.stacks = stacks;
        }

        public Optional<class_9306> getTradedItem(int index) {
            if (index < 0 || index >= this.stacks.size()) {
                return Optional.empty();
            }
            class_1799 stack = this.stacks.get(index);
            return Optional.of(new class_9306(stack.method_41409(), stack.method_7947(), class_9329.method_57865((class_9323)stack.method_57353())));
        }

        public class_1799 getStack(int index) {
            if (index < 0 || index >= this.stacks.size()) {
                return class_1799.field_8037;
            }
            return this.stacks.get(index);
        }
    }

    public static class Builder {
        private final List<Entry> wants = new ArrayList<Entry>();
        private final Entry gives;
        private int maxUses = TradeOffersAccessor.defaultMaxUses();
        private int tradeExperience;
        private float priceMultiplier = TradeOffersAccessor.lowPriceMultiplier();
        private TradeModifier<?> tradeModifier;

        public Builder(Entry gives) {
            this.gives = gives;
        }

        public Trade build() {
            return Trade.of(this.wants, this.gives, this.maxUses, this.tradeExperience, this.priceMultiplier, this.tradeModifier);
        }

        public Builder wants(Entry entry) {
            if (this.wants.size() >= 2) {
                throw new IllegalArgumentException("Tried to add more than 2 wanted entries");
            }
            this.wants.add(entry);
            return this;
        }

        public Builder maxUses(int maxUses) {
            this.maxUses = maxUses;
            return this;
        }

        public Builder tradeExperience(int tradeExperience) {
            this.tradeExperience = tradeExperience;
            return this;
        }

        public Builder tradeModifier(TradeModifier<?> tradeModifier) {
            this.tradeModifier = tradeModifier;
            return this;
        }

        public Builder priceMultiplier(float priceMultiplier) {
            this.priceMultiplier = priceMultiplier;
            return this;
        }
    }
}

