/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.village.trade.modifier.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.errorcraft.itematic.util.Range;
import net.errorcraft.itematic.village.trade.Trade;
import net.errorcraft.itematic.village.trade.modifier.TradeModifier;
import net.errorcraft.itematic.village.trade.modifier.TradeModifierType;
import net.errorcraft.itematic.village.trade.modifier.TradeModifierTypes;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_3532;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;
import net.minecraft.class_9306;
import net.minecraft.class_9323;
import net.minecraft.class_9329;

public record SingleEnchantmentTradeModifier(int index, int baseRandomCost, int perLevelRandomCost, int perLevelCost, class_6885<class_1887> enchantments, Range.IntegerRange levels) implements TradeModifier<SingleEnchantmentTradeModifier>
{
    public static final MapCodec<SingleEnchantmentTradeModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Trade.WANTED_INDEX_CODEC.fieldOf("index").forGetter(SingleEnchantmentTradeModifier::index), (App)Codec.INT.fieldOf("base_random_cost").forGetter(SingleEnchantmentTradeModifier::baseRandomCost), (App)Codec.INT.fieldOf("per_level_random_cost").forGetter(SingleEnchantmentTradeModifier::perLevelRandomCost), (App)Codec.INT.fieldOf("per_level_cost").forGetter(SingleEnchantmentTradeModifier::perLevelCost), (App)class_6895.method_40340((class_5321)class_7924.field_41265).fieldOf("enchantments").forGetter(SingleEnchantmentTradeModifier::enchantments), (App)Range.INT_CODEC.fieldOf("levels").forGetter(SingleEnchantmentTradeModifier::levels)).apply((Applicative)instance, SingleEnchantmentTradeModifier::new));
    private static final int TREASURE_BONUS_FACTOR = 2;

    public static SingleEnchantmentTradeModifier of(int index, int baseRandomCost, int perLevelRandomCost, int perLevelCost, class_6885<class_1887> enchantments) {
        return new SingleEnchantmentTradeModifier(index, baseRandomCost, perLevelRandomCost, perLevelCost, enchantments, Range.IntegerRange.atLeast(1));
    }

    @Override
    public TradeModifierType<SingleEnchantmentTradeModifier> type() {
        return TradeModifierTypes.SINGLE_ENCHANTMENT;
    }

    @Override
    public Optional<class_9306> apply(Trade.Input wants, class_1799 gives, class_47 context) {
        class_5819 random = context.method_294();
        this.enchantments.method_40243(random).ifPresent(entry -> this.apply(wants.getStack(this.index), gives, random, (class_1887)entry.comp_349()));
        return Optional.of(new class_9306(gives.method_41409(), gives.method_7947(), class_9329.method_57865((class_9323)gives.method_57353())));
    }

    private void apply(class_1799 wants, class_1799 gives, class_5819 random, class_1887 enchantment) {
        int minLevel = Math.max(enchantment.method_8187(), (Integer)this.levels.min());
        int maxLevel = Math.min(enchantment.method_8183(), (Integer)this.levels.max());
        int level = class_3532.method_15395((class_5819)random, (int)minLevel, (int)maxLevel);
        gives.method_7978(enchantment, level);
        int count = random.method_43048(this.baseRandomCost + level * this.perLevelRandomCost) + level * this.perLevelCost;
        if (enchantment.method_8193()) {
            count *= 2;
        }
        wants.itematic$tryIncrement(count);
    }
}

