/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.item.component.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.errorcraft.itematic.item.ItemStackConsumer;
import net.errorcraft.itematic.item.component.ItemComponent;
import net.errorcraft.itematic.item.component.ItemComponentType;
import net.errorcraft.itematic.item.component.ItemComponentTypes;
import net.errorcraft.itematic.item.placement.BlockPlacer;
import net.errorcraft.itematic.item.placement.block.picker.BlockPicker;
import net.errorcraft.itematic.item.placement.block.picker.pickers.AttachedToSideBlockPicker;
import net.errorcraft.itematic.item.placement.block.picker.pickers.SimpleBlockPicker;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2480;
import net.minecraft.class_2561;
import net.minecraft.class_5328;
import net.minecraft.class_6880;
import net.minecraft.class_9288;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public record BlockItemComponent(BlockPicker<?> block, boolean operatorOnly) implements ItemComponent<BlockItemComponent>
{
    public static final Codec<BlockItemComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPicker.CODEC.fieldOf("block").forGetter(BlockItemComponent::block), (App)Codec.BOOL.optionalFieldOf("operator_only", (Object)false).forGetter(BlockItemComponent::operatorOnly)).apply((Applicative)instance, BlockItemComponent::new));

    public static BlockItemComponent of(BlockPicker<?> block, boolean operatorOnly) {
        return new BlockItemComponent(block, operatorOnly);
    }

    public static BlockItemComponent of(class_6880<class_2248> block) {
        return BlockItemComponent.of(new SimpleBlockPicker(block), false);
    }

    public static BlockItemComponent operator(class_6880<class_2248> block) {
        return BlockItemComponent.of(new SimpleBlockPicker(block), true);
    }

    public static BlockItemComponent attachedToSide(class_6880<class_2248> attachedBlock, class_6880<class_2248> otherBlock, class_2350 attachedSide) {
        return BlockItemComponent.of(new AttachedToSideBlockPicker(attachedBlock, otherBlock, attachedSide), false);
    }

    @Override
    public ItemComponentType<BlockItemComponent> type() {
        return ItemComponentTypes.BLOCK;
    }

    @Override
    public Codec<BlockItemComponent> codec() {
        return CODEC;
    }

    @Override
    public class_1269 useOnBlock(class_1838 context, ItemStackConsumer resultStackConsumer) {
        BlockPlacer placer = BlockPlacer.of(context, resultStackConsumer, this.block, this.operatorOnly, true);
        return placer.place();
    }

    @Override
    public void addComponents(class_9323.class_9324 builder) {
        ((class_2248)this.block.defaultBlock().comp_349()).itematic$addComponents(builder);
    }

    @Override
    public void appendTooltip(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        ((class_2248)this.block.defaultBlock().comp_349()).method_9568(stack, context, tooltip, type);
    }

    public boolean canBeNested() {
        return !(this.block.defaultBlock().comp_349() instanceof class_2480);
    }

    public void onDestroyed(class_1542 item) {
        class_9288 container = (class_9288)item.method_6983().method_57379(class_9334.field_49622, (Object)class_9288.field_49334);
        if (container != null) {
            class_5328.method_33263((class_1542)item, (Iterable)container.method_59715());
        }
    }
}

