/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.item.component.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.errorcraft.itematic.component.ItematicDataComponentTypes;
import net.errorcraft.itematic.component.type.UseDurationDataComponent;
import net.errorcraft.itematic.item.ItemStackConsumer;
import net.errorcraft.itematic.item.component.ItemComponent;
import net.errorcraft.itematic.item.component.ItemComponentType;
import net.errorcraft.itematic.item.component.ItemComponentTypes;
import net.errorcraft.itematic.item.use.provider.IntegerProvider;
import net.errorcraft.itematic.item.use.provider.providers.ConstantIntegerProvider;
import net.errorcraft.itematic.serialization.ItematicCodecs;
import net.errorcraft.itematic.util.UseActionUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_3542;
import net.minecraft.class_9323;

public record UseableItemComponent(UseDurationDataComponent ticks, class_1839 animation, Set<Pass> passes) implements ItemComponent<UseableItemComponent>
{
    public static final Codec<UseableItemComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UseDurationDataComponent.MAP_CODEC.forGetter(UseableItemComponent::ticks), (App)UseActionUtil.CODEC.optionalFieldOf("animation", (Object)class_1839.field_8952).forGetter(UseableItemComponent::animation), (App)ItematicCodecs.setCodec(Pass.CODEC).optionalFieldOf("passes", Pass.DEFAULT_PASSES).forGetter(UseableItemComponent::passes)).apply((Applicative)instance, UseableItemComponent::new));

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public ItemComponentType<UseableItemComponent> type() {
        return ItemComponentTypes.USEABLE;
    }

    @Override
    public Codec<UseableItemComponent> codec() {
        return CODEC;
    }

    @Override
    public class_1269 use(class_1937 world, class_1657 user, class_1268 hand, class_1799 stack, ItemStackConsumer resultStackConsumer) {
        if (this.isUnuseable(Pass.NORMAL)) {
            return class_1269.field_5811;
        }
        return UseableItemComponent.tryStartUsing(world, user, hand, stack);
    }

    @Override
    public class_1269 useOnBlock(class_1838 context, ItemStackConsumer resultStackConsumer) {
        if (this.isUnuseable(Pass.BLOCK)) {
            return class_1269.field_5811;
        }
        return UseableItemComponent.tryStartUsing(context.method_8045(), context.method_8036(), context.method_20287(), context.method_8041());
    }

    @Override
    public class_1269 useOnEntity(class_1657 user, class_1309 target, class_1268 hand, class_1799 stack, ItemStackConsumer resultStackConsumer) {
        if (this.isUnuseable(Pass.ENTITY)) {
            return class_1269.field_5811;
        }
        return UseableItemComponent.tryStartUsing(user.method_37908(), user, hand, stack);
    }

    private static class_1269 tryStartUsing(class_1937 world, class_1657 user, class_1268 hand, class_1799 stack) {
        if (!stack.itematic$mayStartUsing(world, user, hand, stack)) {
            return class_1269.field_5811;
        }
        UseDurationDataComponent useDurationDataComponent = (UseDurationDataComponent)stack.method_57824(ItematicDataComponentTypes.USE_DURATION);
        if (useDurationDataComponent == null) {
            return class_1269.field_5811;
        }
        if (useDurationDataComponent.startUsing(world, user, hand, stack)) {
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    @Override
    public void addComponents(class_9323.class_9324 builder) {
        builder.method_57840(ItematicDataComponentTypes.USE_DURATION, (Object)this.ticks);
        builder.method_57840(ItematicDataComponentTypes.USE_ANIMATION, (Object)this.animation);
    }

    private boolean isUnuseable(Pass pass) {
        return !this.passes.contains((Object)pass);
    }

    public static class Builder {
        private IntegerProvider ticks;
        private class_1839 animation = class_1839.field_8952;
        private Set<Pass> passes = Pass.DEFAULT_PASSES;

        private Builder() {
        }

        public UseableItemComponent build() {
            return new UseableItemComponent(this.ticks == null ? UseDurationDataComponent.INDEFINITE : new UseDurationDataComponent(this.ticks), this.animation, this.passes);
        }

        public Builder ticks(int ticks) {
            this.ticks = new ConstantIntegerProvider(ticks);
            return this;
        }

        public Builder ticks(IntegerProvider ticks) {
            this.ticks = ticks;
            return this;
        }

        public Builder animation(class_1839 animation) {
            this.animation = animation;
            return this;
        }

        public Builder passes(Pass ... passes) {
            this.passes = Set.of(passes);
            return this;
        }
    }

    public static enum Pass implements class_3542
    {
        NORMAL("normal"),
        BLOCK("block"),
        ENTITY("entity");

        public static final Set<Pass> DEFAULT_PASSES;
        public static final Codec<Pass> CODEC;
        private final String name;

        private Pass(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            DEFAULT_PASSES = Set.of(NORMAL);
            CODEC = class_3542.method_28140(Pass::values);
        }
    }
}

