/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.world.action.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.errorcraft.itematic.item.component.ItemComponentTypes;
import net.errorcraft.itematic.world.action.Action;
import net.errorcraft.itematic.world.action.ActionType;
import net.errorcraft.itematic.world.action.ActionTypes;
import net.errorcraft.itematic.world.action.actions.PlaceBlockAction;
import net.errorcraft.itematic.world.action.context.ActionContext;
import net.errorcraft.itematic.world.action.context.parameter.ActionContextParameter;

public record PlaceBlockFromItemAction(ActionContextParameter position, boolean decrementCount) implements Action<PlaceBlockFromItemAction>
{
    public static final MapCodec<PlaceBlockFromItemAction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ActionContextParameter.CODEC.fieldOf("position").forGetter(PlaceBlockFromItemAction::position), (App)Codec.BOOL.optionalFieldOf("decrement_count", (Object)true).forGetter(PlaceBlockFromItemAction::decrementCount)).apply((Applicative)instance, PlaceBlockFromItemAction::new));

    public static PlaceBlockFromItemAction of(ActionContextParameter position, boolean decrementCount) {
        return new PlaceBlockFromItemAction(position, decrementCount);
    }

    @Override
    public ActionType<PlaceBlockFromItemAction> type() {
        return ActionTypes.PLACE_BLOCK_FROM_ITEM;
    }

    @Override
    public boolean execute(ActionContext context) {
        return context.stack().itematic$getComponent(ItemComponentTypes.BLOCK).map(component -> {
            PlaceBlockAction action = PlaceBlockAction.of(component.block(), this.position, this.decrementCount);
            return action.execute(context);
        }).orElse(false);
    }
}

