/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.world.action.context;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.errorcraft.itematic.item.ItemStackConsumer;
import net.errorcraft.itematic.loot.context.ItematicLootContextParameters;
import net.errorcraft.itematic.loot.context.ItematicLootContextTypes;
import net.errorcraft.itematic.util.PositionUtil;
import net.errorcraft.itematic.world.action.context.parameter.ActionContextParameter;
import net.errorcraft.itematic.world.action.context.parameter.ActionContextParameters;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2968;
import net.minecraft.class_2991;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_47;
import net.minecraft.class_6880;
import net.minecraft.class_8567;

public class ActionContext {
    private final Builder builder;
    private final class_3218 world;
    protected final Map<ActionContextParameter, class_1297> entities;
    protected final Map<ActionContextParameter, class_243> positions;
    protected class_2350 side = class_2350.field_11036;
    protected class_1799 stack = class_1799.field_8037;
    protected ItemStackConsumer resultStackConsumer;
    protected class_1304 slot;

    public ActionContext(class_3218 world) {
        this(world, new HashMap<ActionContextParameter, class_1297>(), new HashMap<ActionContextParameter, class_243>());
    }

    private ActionContext(class_3218 world, Map<ActionContextParameter, class_1297> entities, Map<ActionContextParameter, class_243> positions) {
        this.world = world;
        this.entities = entities;
        this.positions = positions;
        this.builder = null;
    }

    private ActionContext(Builder builder) {
        this.builder = builder;
        this.world = builder.world;
        this.entities = new HashMap<ActionContextParameter, class_1297>(builder.entities);
        this.positions = new HashMap<ActionContextParameter, class_243>(builder.positions);
        this.side = builder.side;
        this.stack = builder.stack;
        this.resultStackConsumer = builder.resultStackConsumer;
        this.slot = builder.slot;
    }

    public static Builder builder(class_3218 world) {
        return new Builder(world);
    }

    public static Builder builder(class_3218 world, class_1799 stack, ItemStackConsumer resultStackConsumer) {
        return ActionContext.builder(world).stack(stack).resultStackConsumer(resultStackConsumer);
    }

    public static Builder builder(class_3218 world, class_1799 stack, ItemStackConsumer resultStackConsumer, class_1304 slot) {
        return ActionContext.builder(world, stack, resultStackConsumer).slot(slot);
    }

    public static Builder builder(class_3218 world, class_1799 stack, ItemStackConsumer resultStackConsumer, class_1268 hand) {
        if (hand == null) {
            return ActionContext.builder(world, stack, resultStackConsumer);
        }
        return ActionContext.builder(world, stack, resultStackConsumer, hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
    }

    public Builder builderForCopy() {
        return this.builder;
    }

    public class_47 createLootContext(ActionContextParameters parameters) {
        class_8567 set = new class_8567.class_8568(this.world).method_51874(class_181.field_1226, (Object)this.entities.get((Object)parameters.entity())).method_51874(class_181.field_24424, (Object)this.position(parameters.position())).method_51874(class_181.field_1229, (Object)this.stack).method_51874(ItematicLootContextParameters.SIDE, (Object)this.side).method_51875(ItematicLootContextTypes.ACTION);
        return new class_47.class_48(set).method_309(Optional.empty());
    }

    public class_2168 createCommandSource(ActionContextParameters parameters, class_2991 functionManager) {
        return functionManager.method_12899().method_9232(this.entities.get((Object)parameters.entity())).method_9208(this.positions.get((Object)parameters.position()));
    }

    public class_1838 createItemUsageContext(ActionContextParameter position) {
        return new class_1838((class_1937)this.world, (class_1657)this.player(ActionContextParameter.THIS).orElse(null), this.hand(), this.stack(), new class_3965(this.position(position), this.side(), this.blockPos(position), false));
    }

    public class_1750 createItemPlacementContext(ActionContextParameter position, class_6880<class_2248> block) {
        if (this.entity(ActionContextParameter.THIS).isPresent()) {
            class_1750 placementContext = new class_1750(this.createItemUsageContext(position));
            return ((class_2248)block.comp_349()).itematic$placementContext(placementContext);
        }
        class_2338 pos = this.blockPos(position);
        class_2350 useSide = this.world.method_22347(pos.method_10074()) ? this.side : class_2350.field_11036;
        return new class_2968((class_1937)this.world, pos, this.side, this.stack, useSide);
    }

    public class_3218 world() {
        return this.world;
    }

    public Optional<class_1297> entity(ActionContextParameter parameter) {
        return Optional.ofNullable(this.entities.get((Object)parameter));
    }

    public Optional<class_1309> livingEntity(ActionContextParameter parameter) {
        return this.entity(parameter).map(entity -> {
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                return livingEntity;
            }
            return null;
        });
    }

    public Optional<class_1657> player(ActionContextParameter parameter) {
        return this.entity(parameter).map(entity -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                return player;
            }
            return null;
        });
    }

    public class_243 position(ActionContextParameter parameter) {
        class_243 position = this.positions.get((Object)parameter);
        if (position == null) {
            return this.world.method_43126().method_46558();
        }
        return position;
    }

    public class_2338 blockPos(ActionContextParameter parameter) {
        return class_2338.method_49638((class_2374)this.position(parameter));
    }

    public class_2350 side() {
        return this.side;
    }

    public class_1799 stack() {
        return this.stack;
    }

    public ItemStackConsumer resultStackConsumer() {
        return this.resultStackConsumer;
    }

    public void setResultStack(class_1799 stack) {
        if (this.resultStackConsumer == null) {
            return;
        }
        this.resultStackConsumer.set(stack);
    }

    public Optional<class_1304> slot() {
        return Optional.ofNullable(this.slot);
    }

    public class_1268 hand() {
        if (this.slot == null) {
            return null;
        }
        return switch (this.slot) {
            case class_1304.field_6173 -> class_1268.field_5808;
            case class_1304.field_6171 -> class_1268.field_5810;
            default -> null;
        };
    }

    public static class Builder {
        private final class_3218 world;
        private final Map<ActionContextParameter, class_1297> entities = new HashMap<ActionContextParameter, class_1297>();
        private final Map<ActionContextParameter, class_243> positions = new HashMap<ActionContextParameter, class_243>();
        private class_2350 side = class_2350.field_11036;
        private class_1799 stack = class_1799.field_8037;
        private ItemStackConsumer resultStackConsumer;
        private class_1304 slot;

        private Builder(class_3218 world) {
            this.world = world;
        }

        public ActionContext build() {
            return new ActionContext(this);
        }

        public Builder entity(ActionContextParameter parameter, class_1297 entity) {
            this.entities.put(parameter, entity);
            return this;
        }

        public Builder entityPosition(ActionContextParameter parameter, class_1297 entity) {
            this.entities.put(parameter, entity);
            if (entity != null) {
                this.positions.put(parameter, entity.method_19538());
            }
            return this;
        }

        public Builder position(ActionContextParameter parameter, class_2338 position) {
            return this.position(parameter, class_243.method_24955((class_2382)position));
        }

        public Builder position(ActionContextParameter parameter, class_2374 position) {
            return this.position(parameter, PositionUtil.vec3d(position));
        }

        public Builder position(ActionContextParameter parameter, class_243 position) {
            if (position == null) {
                throw new IllegalArgumentException("Position was null");
            }
            this.positions.put(parameter, position);
            return this;
        }

        public Builder side(class_2350 side) {
            if (side == null) {
                throw new IllegalArgumentException("Side was null");
            }
            this.side = side;
            return this;
        }

        public Builder stack(class_1799 stack) {
            if (stack == null) {
                throw new IllegalArgumentException("Item stack was null");
            }
            this.stack = stack;
            return this;
        }

        public Builder resultStackConsumer(ItemStackConsumer resultStackConsumer) {
            this.resultStackConsumer = resultStackConsumer;
            return this;
        }

        public Builder slot(class_1304 slot) {
            this.slot = slot;
            return this;
        }
    }
}

