/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.world.action.sequence.handler.handlers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.errorcraft.itematic.world.action.Action;
import net.errorcraft.itematic.world.action.ActionEntry;
import net.errorcraft.itematic.world.action.context.ActionContext;
import net.errorcraft.itematic.world.action.sequence.handler.SequenceHandler;
import net.errorcraft.itematic.world.action.sequence.handler.SequenceHandlerType;
import net.errorcraft.itematic.world.action.sequence.handler.SequenceHandlerTypes;
import net.minecraft.class_6880;

public record PassingSequenceHandler(List<Entry> entries) implements SequenceHandler<PassingSequenceHandler>
{
    public static final Codec<PassingSequenceHandler> CODEC = Entry.CODEC.listOf().xmap(PassingSequenceHandler::new, PassingSequenceHandler::entries);

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public SequenceHandlerType<PassingSequenceHandler> type() {
        return SequenceHandlerTypes.PASSING;
    }

    @Override
    public boolean handle(ActionContext context) {
        for (Entry entry : this.entries) {
            if (entry.execute(context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterable<class_6880<ActionEntry>> iterateEntries() {
        return () -> this.entries.stream().map(Entry::action).iterator();
    }

    public static class Builder
    implements SequenceHandler.Builder<PassingSequenceHandler, Builder> {
        private final List<Entry> entries = new ArrayList<Entry>();

        @Override
        public PassingSequenceHandler build() {
            return new PassingSequenceHandler(this.entries);
        }

        @Override
        public Builder add(class_6880<ActionEntry> entry) {
            this.entries.add(Entry.required(entry));
            return this;
        }

        public Builder addOptional(Action<?> action) {
            return this.addOptional((class_6880<ActionEntry>)class_6880.method_40223((Object)ActionEntry.of(action)));
        }

        public Builder addOptional(class_6880<ActionEntry> entry) {
            this.entries.add(Entry.optional(entry));
            return this;
        }
    }

    public record Entry(class_6880<ActionEntry> action, boolean optional) {
        public static final Codec<Entry> ELEMENT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ActionEntry.REGISTRY_CODEC.fieldOf("entry").forGetter(Entry::action), (App)Codec.BOOL.optionalFieldOf("optional", (Object)false).forGetter(Entry::optional)).apply((Applicative)instance, Entry::new));
        public static final Codec<Entry> CODEC = Codec.either(ELEMENT_CODEC, ActionEntry.REGISTRY_CODEC).xmap(either -> (Entry)either.map(entry -> entry, Entry::required), entry -> entry.optional ? Either.left((Object)entry) : Either.right(entry.action));

        private boolean execute(ActionContext context) {
            if (((ActionEntry)this.action.comp_349()).execute(context).orElse(false).booleanValue()) {
                return true;
            }
            return this.optional;
        }

        public static Entry required(class_6880<ActionEntry> action) {
            return new Entry(action, false);
        }

        public static Entry optional(class_6880<ActionEntry> action) {
            return new Entry(action, true);
        }
    }
}

