/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.item.component.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.errorcraft.itematic.entity.initializer.EntityInitializer;
import net.errorcraft.itematic.entity.initializer.initializers.SimpleEntityInitializer;
import net.errorcraft.itematic.fluid.FluidKeys;
import net.errorcraft.itematic.inventory.StackReferenceUtil;
import net.errorcraft.itematic.item.ItemKeys;
import net.errorcraft.itematic.item.ItemStackConsumer;
import net.errorcraft.itematic.item.component.ItemComponent;
import net.errorcraft.itematic.item.component.ItemComponentType;
import net.errorcraft.itematic.item.component.ItemComponentTypes;
import net.errorcraft.itematic.item.component.components.DispensableItemComponent;
import net.errorcraft.itematic.item.component.components.StackableItemComponent;
import net.errorcraft.itematic.item.dispense.behavior.DispenseBehavior;
import net.errorcraft.itematic.item.dispense.behavior.DispenseBehaviors;
import net.errorcraft.itematic.item.placement.BlockPlacer;
import net.errorcraft.itematic.item.placement.EntityPlacer;
import net.errorcraft.itematic.item.placement.FluidPlacer;
import net.errorcraft.itematic.item.placement.Placer;
import net.errorcraft.itematic.item.placement.block.picker.BlockPicker;
import net.errorcraft.itematic.item.placement.block.picker.pickers.SimpleBlockPicker;
import net.errorcraft.itematic.mixin.item.ItemAccessor;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_239;
import net.minecraft.class_3414;
import net.minecraft.class_3611;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_5328;
import net.minecraft.class_5630;
import net.minecraft.class_5761;
import net.minecraft.class_6880;
import net.minecraft.class_6899;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_9279;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public record BucketItemComponent(Optional<class_6880<class_3611>> fluid, Optional<EntityTarget> entity, Optional<BlockPicker<?>> block, Optional<class_6880<class_3414>> emptyingSound, Optional<class_6880<class_1792>> transformsInto) implements ItemComponent<BucketItemComponent>
{
    public static final Codec<BucketItemComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6899.method_40400((class_5321)class_7924.field_41270).optionalFieldOf("fluid").forGetter(BucketItemComponent::fluid), (App)EntityTarget.CODEC.optionalFieldOf("entity").forGetter(BucketItemComponent::entity), (App)BlockPicker.CODEC.optionalFieldOf("block").forGetter(BucketItemComponent::block), (App)class_3414.field_41699.optionalFieldOf("emptying_sound_event").forGetter(BucketItemComponent::emptyingSound), (App)class_6899.method_40400((class_5321)class_7924.field_41197).optionalFieldOf("transforms_into").forGetter(BucketItemComponent::transformsInto)).apply((Applicative)instance, BucketItemComponent::new));

    public static ItemComponent<?>[] fluid(class_6880<class_3611> fluid, class_7871<DispenseBehavior> dispenseBehaviors) {
        return new ItemComponent[]{StackableItemComponent.of(16), new BucketItemComponent(Optional.of(fluid), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()), DispensableItemComponent.of((class_6880<DispenseBehavior>)dispenseBehaviors.method_46747(DispenseBehaviors.USE_BUCKET))};
    }

    public static ItemComponent<?>[] fluid(class_6880<class_3611> fluid, class_6880<class_3414> emptyingSound, class_7871<class_1792> items, class_7871<DispenseBehavior> dispenseBehaviors) {
        return new ItemComponent[]{StackableItemComponent.of(1), new BucketItemComponent(Optional.of(fluid), Optional.empty(), Optional.empty(), Optional.of(emptyingSound), Optional.of(items.method_46747(ItemKeys.BUCKET))), DispensableItemComponent.of((class_6880<DispenseBehavior>)dispenseBehaviors.method_46747(DispenseBehaviors.USE_BUCKET))};
    }

    public static ItemComponent<?>[] entity(class_6880<class_3611> fluid, class_6880<class_1299<?>> entity, class_6880<class_3414> emptyingSound, class_7871<class_1792> items, class_7871<DispenseBehavior> dispenseBehaviors) {
        return new ItemComponent[]{StackableItemComponent.of(1), new BucketItemComponent(Optional.of(fluid), Optional.of(EntityTarget.ofRequired(entity)), Optional.empty(), Optional.of(emptyingSound), Optional.of(items.method_46747(ItemKeys.BUCKET))), DispensableItemComponent.of((class_6880<DispenseBehavior>)dispenseBehaviors.method_46747(DispenseBehaviors.USE_BUCKET))};
    }

    public static ItemComponent<?>[] block(class_6880<class_2248> block, class_6880<class_3414> emptyingSound, class_7871<class_1792> items, class_7871<DispenseBehavior> dispenseBehaviors) {
        return new ItemComponent[]{StackableItemComponent.of(1), new BucketItemComponent(Optional.empty(), Optional.empty(), Optional.of(new SimpleBlockPicker(block)), Optional.of(emptyingSound), Optional.of(items.method_46747(ItemKeys.BUCKET))), DispensableItemComponent.of((class_6880<DispenseBehavior>)dispenseBehaviors.method_46747(DispenseBehaviors.USE_BUCKET))};
    }

    @Override
    public ItemComponentType<BucketItemComponent> type() {
        return ItemComponentTypes.BUCKET;
    }

    @Override
    public Codec<BucketItemComponent> codec() {
        return CODEC;
    }

    @Override
    public class_1269 use(class_1937 world, class_1657 user, class_1268 hand, class_1799 stack, ItemStackConsumer resultStackConsumer) {
        class_3965 blockHitResult = ItemAccessor.raycast(world, user, this.getFluidHandling());
        if (blockHitResult.method_17783() != class_239.class_240.field_1332) {
            return class_1269.field_5811;
        }
        return this.place(world, user, hand, stack, resultStackConsumer, blockHitResult);
    }

    @Override
    public void addComponents(class_9323.class_9324 builder) {
        if (this.entity.isPresent()) {
            builder.method_57840(class_9334.field_49610, (Object)class_9279.field_49302);
        }
    }

    public class_1269 place(class_1937 world, @Nullable class_1657 user, class_1268 hand, class_1799 stack, ItemStackConsumer resultStackConsumer, class_3965 blockHitResult) {
        class_5630 stackReference = StackReferenceUtil.of(stack);
        class_1269 result = class_1269.field_5811;
        if (this.fluid.isPresent()) {
            FluidPlacer fluidPlacer = FluidPlacer.of(stack, arg_0 -> ((class_5630)stackReference).method_32332(arg_0), world, blockHitResult, user, this.fluid.get(), (class_6880<class_3414>)((class_6880)this.emptyingSound.orElse(null)));
            result = BucketItemComponent.place(fluidPlacer, result);
        }
        if (this.block.isPresent() && result != class_1269.field_5814) {
            class_1838 context = new class_1838(world, user, hand, stack, blockHitResult);
            BlockPlacer blockPlacer = BlockPlacer.of(context, arg_0 -> ((class_5630)stackReference).method_32332(arg_0), this.block.get(), false, false);
            result = BucketItemComponent.place(blockPlacer, result);
        }
        if ((result = this.tryPlaceEntity(world, user, hand, stack, blockHitResult, stackReference, result)).method_23665()) {
            resultStackConsumer.set(this.getResultStack(user, stack, stackReference.method_32327()));
        }
        return result;
    }

    private class_3959.class_242 getFluidHandling() {
        if (this.fluid.isEmpty()) {
            return class_3959.class_242.field_1348;
        }
        if (this.fluid.get().method_40225(FluidKeys.EMPTY)) {
            return class_3959.class_242.field_1345;
        }
        return class_3959.class_242.field_1348;
    }

    private class_1269 tryPlaceEntity(class_1937 world, @Nullable class_1657 user, class_1268 hand, class_1799 stack, class_3965 blockHitResult, class_5630 stackReference, class_1269 currentResult) {
        if (this.entity.isEmpty()) {
            return currentResult;
        }
        if (this.entity.get().requireOtherSuccessfulPlacement && !currentResult.method_23665()) {
            return currentResult;
        }
        if (world.method_8608() || currentResult == class_1269.field_5814) {
            return currentResult;
        }
        EntityPlacer entityPlacer = EntityPlacer.bucket(stack, arg_0 -> ((class_5630)stackReference).method_32332(arg_0), world, blockHitResult, user, this.entity.get().entity, hand);
        return BucketItemComponent.place(entityPlacer, currentResult);
    }

    private static class_1269 place(Placer placer, class_1269 currentResult) {
        class_1269 result = placer.place();
        return currentResult.itematic$merge(result);
    }

    private class_1799 getResultStack(@Nullable class_1657 player, class_1799 currentStack, class_1799 possibleNewStack) {
        if (currentStack == possibleNewStack) {
            possibleNewStack = this.transformsInto.map(class_1799::new).orElse(possibleNewStack);
        }
        if (player == null) {
            currentStack.method_7934(1);
            return possibleNewStack;
        }
        return class_5328.method_30012((class_1799)currentStack, (class_1657)player, (class_1799)possibleNewStack);
    }

    public static void initializeBucketEntity(class_1297 entity, class_1799 stack) {
        if (entity instanceof class_5761) {
            class_5761 bucketable = (class_5761)entity;
            bucketable.method_35170(((class_9279)stack.method_57825(class_9334.field_49610, (Object)class_9279.field_49302)).method_57461());
            bucketable.method_6454(true);
        }
    }

    public record EntityTarget(EntityInitializer<?> entity, boolean requireOtherSuccessfulPlacement) {
        public static final Codec<EntityTarget> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityInitializer.CODEC.fieldOf("entity").forGetter(EntityTarget::entity), (App)Codec.BOOL.optionalFieldOf("require_other_successful_placement", (Object)false).forGetter(EntityTarget::requireOtherSuccessfulPlacement)).apply((Applicative)instance, EntityTarget::new));

        public static EntityTarget ofRequired(class_6880<class_1299<?>> entity) {
            return new EntityTarget(SimpleEntityInitializer.of((class_1299)entity.comp_349()), true);
        }
    }
}

