/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.item.component.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.errorcraft.itematic.component.type.WeaponAttackDamageDataComponent;
import net.errorcraft.itematic.enchantment.EnchantmentTags;
import net.errorcraft.itematic.item.component.ItemComponent;
import net.errorcraft.itematic.item.component.ItemComponentType;
import net.errorcraft.itematic.item.component.ItemComponentTypes;
import net.errorcraft.itematic.item.component.components.EnchantableItemComponent;
import net.errorcraft.itematic.item.component.components.ForgeableItemComponent;
import net.errorcraft.itematic.item.component.components.RepairableItemComponent;
import net.errorcraft.itematic.item.component.components.StackableItemComponent;
import net.errorcraft.itematic.item.component.components.ToolItemComponent;
import net.errorcraft.itematic.item.component.components.WeaponItemComponent;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1887;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9424;

public record DamageableItemComponent(int durability, Optional<class_6880<class_3414>> breakSound, boolean preserveItem) implements ItemComponent<DamageableItemComponent>
{
    public static final Codec<DamageableItemComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33442.fieldOf("durability").forGetter(DamageableItemComponent::durability), (App)class_3414.field_41699.optionalFieldOf("break_sound").forGetter(DamageableItemComponent::breakSound), (App)Codec.BOOL.optionalFieldOf("preserve_item", (Object)false).forGetter(DamageableItemComponent::preserveItem)).apply((Applicative)instance, DamageableItemComponent::new));

    public static DamageableItemComponent of(int durability) {
        return new DamageableItemComponent(durability, Optional.empty(), false);
    }

    public static DamageableItemComponent of(int durability, class_6880<class_3414> breakSound) {
        return new DamageableItemComponent(durability, Optional.of(breakSound), false);
    }

    public static DamageableItemComponent ofPreserved(int durability) {
        return new DamageableItemComponent(durability, Optional.empty(), true);
    }

    @SafeVarargs
    public static ItemComponent<?>[] sword(class_1832 material, class_6862<class_1792> repairItemsTag, class_6862<class_1299<?>> ... proficientEntityTypeTags) {
        double attackDamage = 4.0 + (double)material.method_8028();
        return new ItemComponent[]{StackableItemComponent.of(1), DamageableItemComponent.of(material.method_8025()), ToolItemComponent.builder(2).rule(class_9424.class_9425.method_58431(List.of(class_2246.field_10343), (float)15.0f)).rule(class_9424.class_9425.method_58433((class_6862)class_3481.field_44469, (float)1.5f)).build(), WeaponItemComponent.of(1, attackDamage, 0.4, (WeaponAttackDamageDataComponent.Rule[])Arrays.stream(proficientEntityTypeTags).map(proficientEntityTypeTag -> WeaponAttackDamageDataComponent.Rule.addsToBase(proficientEntityTypeTag, attackDamage - 1.0)).toArray(WeaponAttackDamageDataComponent.Rule[]::new)), EnchantableItemComponent.enchants(material, EnchantmentTags.SWORD_ENCHANTING), ForgeableItemComponent.of(EnchantmentTags.SWORD_FORGING), RepairableItemComponent.of(repairItemsTag)};
    }

    @SafeVarargs
    public static ItemComponent<?>[] shovel(class_1832 material, class_6862<class_1792> repairItemsTag, class_6862<class_1299<?>> ... proficientEntityTypeTags) {
        return DamageableItemComponent.tool(material, 2.5, 0.25, (class_6862<class_2248>)class_3481.field_33716, EnchantmentTags.SHOVEL_ENCHANTING, EnchantmentTags.SHOVEL_FORGING, repairItemsTag, proficientEntityTypeTags);
    }

    @SafeVarargs
    public static ItemComponent<?>[] pickaxe(class_1832 material, class_6862<class_1792> repairItemsTag, class_6862<class_1299<?>> ... proficientEntityTypeTags) {
        return DamageableItemComponent.tool(material, 2.0, 0.3, (class_6862<class_2248>)class_3481.field_33715, EnchantmentTags.PICKAXE_ENCHANTING, EnchantmentTags.PICKAXE_FORGING, repairItemsTag, proficientEntityTypeTags);
    }

    @SafeVarargs
    public static ItemComponent<?>[] axe(class_1832 material, double attackDamage, double attackSpeed, class_6862<class_1792> repairItemsTag, class_6862<class_1299<?>> ... proficientEntityTypeTags) {
        return DamageableItemComponent.tool(material, attackDamage, attackSpeed, (class_6862<class_2248>)class_3481.field_33713, EnchantmentTags.AXE_ENCHANTING, EnchantmentTags.AXE_FORGING, repairItemsTag, proficientEntityTypeTags);
    }

    @SafeVarargs
    public static ItemComponent<?>[] hoe(class_1832 material, double attackDamage, double attackSpeed, class_6862<class_1792> repairItemsTag, class_6862<class_1299<?>> ... proficientEntityTypeTags) {
        return DamageableItemComponent.tool(material, attackDamage, attackSpeed, (class_6862<class_2248>)class_3481.field_33714, EnchantmentTags.HOE_ENCHANTING, EnchantmentTags.HOE_FORGING, repairItemsTag, proficientEntityTypeTags);
    }

    @Override
    public ItemComponentType<DamageableItemComponent> type() {
        return ItemComponentTypes.DAMAGEABLE;
    }

    @SafeVarargs
    private static ItemComponent<?>[] tool(class_1832 material, double attackDamage, double attackSpeed, class_6862<class_2248> mineableBlocks, class_6862<class_1887> toolEnchantingTag, class_6862<class_1887> toolForgingTag, class_6862<class_1792> repairItemsTag, class_6862<class_1299<?>> ... proficientEntityTypeTags) {
        double realAttackDamage = attackDamage + (double)material.method_8028();
        return new ItemComponent[]{StackableItemComponent.of(1), DamageableItemComponent.of(material.method_8025()), ToolItemComponent.of(material, mineableBlocks), WeaponItemComponent.of(2, realAttackDamage, attackSpeed, (WeaponAttackDamageDataComponent.Rule[])Arrays.stream(proficientEntityTypeTags).map(proficientEntityTypeTag -> WeaponAttackDamageDataComponent.Rule.addsToBase(proficientEntityTypeTag, realAttackDamage - 1.0)).toArray(WeaponAttackDamageDataComponent.Rule[]::new)), EnchantableItemComponent.enchants(material, toolEnchantingTag), ForgeableItemComponent.of(toolForgingTag), RepairableItemComponent.of(repairItemsTag)};
    }

    @Override
    public Codec<DamageableItemComponent> codec() {
        return CODEC;
    }

    @Override
    public void addComponents(class_9323.class_9324 builder) {
        builder.method_57840(class_9334.field_50072, (Object)this.durability);
        builder.method_57840(class_9334.field_49629, (Object)0);
    }

    public int maximumDamage(class_1799 stack) {
        return stack.method_7936() - (this.preserveItem ? 1 : 0);
    }

    public boolean isUsable(class_1799 stack) {
        return stack.method_7919() < this.maximumDamage(stack);
    }
}

