/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.item.event;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.errorcraft.itematic.item.event.ItemEvent;
import net.errorcraft.itematic.registry.ItematicRegistries;
import net.errorcraft.itematic.world.action.ActionEntry;
import net.errorcraft.itematic.world.action.context.ActionContext;
import net.minecraft.class_6880;

public class ItemEventMap {
    public static final ItemEventMap EMPTY = new ItemEventMap();
    public static final Codec<ItemEventMap> CODEC = Codec.simpleMap((Codec)ItematicRegistries.ITEM_EVENT.method_39673(), ActionEntry.REGISTRY_CODEC, ItematicRegistries.ITEM_EVENT).xmap(ItemEventMap::new, v -> v.events).codec();
    private final Map<ItemEvent, class_6880<ActionEntry>> events;

    private ItemEventMap() {
        this(Map.of());
    }

    private ItemEventMap(Map<ItemEvent, class_6880<ActionEntry>> events) {
        this.events = events;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean invokeEvent(ItemEvent event, ActionContext context) {
        class_6880<ActionEntry> entry = this.events.get(event);
        if (entry == null) {
            return false;
        }
        return ((ActionEntry)entry.comp_349()).execute(context).orElse(false);
    }

    public static class Builder {
        private final Map<ItemEvent, class_6880<ActionEntry>> events = new HashMap<ItemEvent, class_6880<ActionEntry>>();

        public ItemEventMap build() {
            return new ItemEventMap(this.events);
        }

        public Builder add(ItemEvent event, ActionEntry action) {
            return this.add(event, (class_6880<ActionEntry>)class_6880.method_40223((Object)action));
        }

        public Builder add(ItemEvent event, class_6880<ActionEntry> entry) {
            if (this.events.containsKey(event)) {
                throw new IllegalArgumentException("Duplicate entry for item event " + String.valueOf(event));
            }
            this.events.put(event, entry);
            return this;
        }
    }
}

