/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.mixin.item;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.errorcraft.itematic.access.item.ItemStackAccess;
import net.errorcraft.itematic.component.ItematicDataComponentTypes;
import net.errorcraft.itematic.component.type.ImmuneToDamageComponent;
import net.errorcraft.itematic.component.type.UseDurationDataComponent;
import net.errorcraft.itematic.item.ItemKeys;
import net.errorcraft.itematic.item.ItematicItemTags;
import net.errorcraft.itematic.item.component.ItemComponent;
import net.errorcraft.itematic.item.component.ItemComponentType;
import net.errorcraft.itematic.item.component.ItemComponentTypes;
import net.errorcraft.itematic.item.event.ItemEvent;
import net.errorcraft.itematic.item.event.ItemEvents;
import net.errorcraft.itematic.util.Util;
import net.errorcraft.itematic.world.action.context.ActionContext;
import net.errorcraft.itematic.world.action.context.parameter.ActionContextParameter;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2069;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6899;
import net.minecraft.class_7922;
import net.minecraft.class_7924;
import net.minecraft.class_9322;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9335;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1799.class})
public abstract class ItemStackExtender
implements class_9322,
ItemStackAccess {
    @Shadow
    @Final
    private static Logger field_8033;
    @Shadow
    @Final
    public static class_1799 field_8037;
    @Shadow
    private int field_8031;
    @Shadow
    @Final
    @Mutable
    class_9335 field_49270;
    @Unique
    private final Set<ItemEvent> activeEvents = new HashSet<ItemEvent>();
    @Unique
    private class_6880<class_1792> entry;
    @Unique
    private ActionContext context;

    @Shadow
    public abstract boolean method_7960();

    @Shadow
    public abstract void method_7956(int var1, class_5819 var2, @Nullable class_3222 var3, Runnable var4);

    @Shadow
    public abstract int method_7919();

    @Shadow
    public abstract void method_7974(int var1);

    @Shadow
    public abstract void method_7934(int var1);

    @Shadow
    public abstract int method_7914();

    @Shadow
    public abstract int method_7947();

    @Redirect(method={"<clinit>"}, at=@At(value="INVOKE", target="Lnet/minecraft/registry/DefaultedRegistry;getEntryCodec()Lcom/mojang/serialization/Codec;"))
    private static Codec<class_6880<class_1792>> registryEntryCodecDoNotUseStaticItemRegistry(class_7922<class_1792> instance) {
        return class_6899.method_40400((class_5321)class_7924.field_41197);
    }

    @Inject(method={"<init>(Lnet/minecraft/registry/entry/RegistryEntry;)V"}, at={@At(value="TAIL")})
    private void registryEntryConstructorSetFields(class_6880<class_1792> entry, CallbackInfo info) {
        this.setFields(entry);
    }

    @Inject(method={"<init>(Lnet/minecraft/registry/entry/RegistryEntry;I)V"}, at={@At(value="TAIL")})
    private void registryEntryConstructorSetFields(class_6880<class_1792> entry, int count, CallbackInfo info) {
        this.setFields(entry);
    }

    @Inject(method={"<init>(Lnet/minecraft/registry/entry/RegistryEntry;ILnet/minecraft/component/ComponentChanges;)V"}, at={@At(value="TAIL")})
    private void componentChangesConstructorSetFields(class_6880<class_1792> item, int count, class_9326 changes, CallbackInfo info) {
        this.entry = item;
        this.field_49270 = class_9335.method_57935((class_9323)((class_1792)item.comp_349()).method_57347(), (class_9326)changes);
        ((class_1792)item.comp_349()).method_7860((class_1799)this);
    }

    @Redirect(method={"<init>(Lnet/minecraft/registry/entry/RegistryEntry;)V", "<init>(Lnet/minecraft/registry/entry/RegistryEntry;I)V", "<init>(Lnet/minecraft/registry/entry/RegistryEntry;ILnet/minecraft/component/ComponentChanges;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/registry/entry/RegistryEntry;value()Ljava/lang/Object;"))
    private static <T> T registryEntryValueReturnNullToPreventUnboundRegistryEntryIssues(class_6880<T> instance) {
        return null;
    }

    @Redirect(method={"<init>(Lnet/minecraft/item/ItemConvertible;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemConvertible;asItem()Lnet/minecraft/item/Item;"))
    private static class_1792 asItemReturnNullToPreventNullPointerExceptionStatic(class_1935 instance) {
        return null;
    }

    @Redirect(method={"<init>(Lnet/minecraft/item/ItemConvertible;ILnet/minecraft/component/ComponentMapImpl;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemConvertible;asItem()Lnet/minecraft/item/Item;"))
    private class_1792 asItemReturnNullToPreventNullPointerException(class_1935 instance) {
        return null;
    }

    @Redirect(method={"<init>(Lnet/minecraft/item/ItemConvertible;I)V", "<init>(Lnet/minecraft/registry/entry/RegistryEntry;ILnet/minecraft/component/ComponentChanges;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/Item;getComponents()Lnet/minecraft/component/ComponentMap;"))
    private static class_9323 getComponentsReturnNullToPreventNullPointerException(class_1792 instance) {
        return null;
    }

    @Redirect(method={"<init>(Lnet/minecraft/registry/entry/RegistryEntry;ILnet/minecraft/component/ComponentChanges;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/component/ComponentMapImpl;create(Lnet/minecraft/component/ComponentMap;Lnet/minecraft/component/ComponentChanges;)Lnet/minecraft/component/ComponentMapImpl;"))
    private static class_9335 createComponentMapReturnNullToPreventNullPointerException(class_9323 baseComponents, class_9326 changes) {
        return null;
    }

    @Inject(method={"<init>(Lnet/minecraft/item/ItemConvertible;ILnet/minecraft/component/ComponentMapImpl;)V"}, at={@At(value="TAIL")})
    private void checkItemValue(class_1935 item, int count, class_9335 components, CallbackInfo info) {
        if (item != null) {
            field_8033.warn(Util.stackTraceMessage("Tried to create an item stack from an item or item-like value directly. This is no longer supported and should be modified to use a holder instead."));
        }
    }

    @Inject(method={"useOnBlock"}, at={@At(value="HEAD")}, cancellable=true)
    public void useOnBlockCheckNullEntry(class_1838 context, CallbackInfoReturnable<class_1269> info) {
        if (this.method_7960()) {
            info.setReturnValue((Object)class_1269.field_5811);
        }
    }

    @Inject(method={"useOnEntity"}, at={@At(value="HEAD")}, cancellable=true)
    public void useOnEntityCheckNullEntry(class_1657 user, class_1309 entity, class_1268 hand, CallbackInfoReturnable<class_1269> info) {
        if (this.method_7960()) {
            info.setReturnValue((Object)class_1269.field_5811);
        }
    }

    @Inject(method={"usageTick"}, at={@At(value="HEAD")}, cancellable=true)
    public void usageTickCheckNullEntry(class_1937 world, class_1309 user, int remainingUseTicks, CallbackInfo info) {
        if (this.method_7960()) {
            info.cancel();
        }
    }

    @Inject(method={"onStoppedUsing"}, at={@At(value="HEAD")}, cancellable=true)
    public void onStoppedUsingCheckNullEntry(class_1937 world, class_1309 user, int remainingUseTicks, CallbackInfo info) {
        if (this.method_7960()) {
            info.cancel();
        }
    }

    @Overwrite
    public class_6880<class_1792> method_41409() {
        return this.entry;
    }

    @Redirect(method={"getItem"}, at=@At(value="FIELD", target="Lnet/minecraft/item/ItemStack;item:Lnet/minecraft/item/Item;", opcode=180))
    private class_1792 getItemGetItemFieldUseRegistryEntryToPreventNullPointerException(class_1799 instance) {
        return (class_1792)this.entry.comp_349();
    }

    @Redirect(method={"copy"}, at=@At(value="NEW", target="(Lnet/minecraft/item/ItemConvertible;ILnet/minecraft/component/ComponentMapImpl;)Lnet/minecraft/item/ItemStack;"))
    private class_1799 newItemStackUseRegistryEntry(class_1935 item, int count, class_9335 components) {
        class_1799 copy = new class_1799(this.entry, count);
        copy.itematic$setComponents(components);
        return copy;
    }

    @ModifyArg(method={"copyComponentsToNewStackIgnoreEmpty"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;<init>(Lnet/minecraft/registry/entry/RegistryEntry;ILnet/minecraft/component/ComponentChanges;)V"))
    private class_6880<class_1792> getEntryUseField(class_6880<class_1792> item) {
        return this.entry;
    }

    @Inject(method={"getMaxCount"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkStackableItemComponent(CallbackInfoReturnable<Integer> info) {
        if (!this.itematic$hasComponent(ItemComponentTypes.STACKABLE)) {
            info.setReturnValue((Object)1);
        }
    }

    @Inject(method={"getRarity"}, at={@At(value="HEAD")}, cancellable=true)
    public void getRarityCheckNullEntry(CallbackInfoReturnable<class_1814> info) {
        if (this.entry == null) {
            info.setReturnValue((Object)class_1814.field_8906);
        }
    }

    @Overwrite
    public Stream<class_6862<class_1792>> method_40133() {
        if (this.entry == null) {
            return Stream.empty();
        }
        return this.entry.method_40228();
    }

    @ModifyReturnValue(method={"isEmpty"}, at={@At(value="TAIL")})
    private boolean checkNullEntryForEmptyStack(boolean original) {
        return original || this.entry == null || this.itematic$isOf(ItemKeys.AIR);
    }

    @Redirect(method={"isStackable"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isDamageable()Z"))
    private boolean isDamageableReturnFalse(class_1799 instance) {
        return false;
    }

    @Overwrite
    public boolean method_31573(class_6862<class_1792> tag) {
        if (this.method_7960()) {
            return false;
        }
        return this.entry.method_40220(tag);
    }

    @Overwrite
    public boolean method_41407(Predicate<class_6880<class_1792>> predicate) {
        if (this.method_7960()) {
            return false;
        }
        return predicate.test(this.entry);
    }

    @Overwrite
    public boolean method_41406(class_6880<class_1792> itemEntry) {
        if (this.method_7960()) {
            return false;
        }
        return this.entry == itemEntry;
    }

    @Inject(method={"isIn(Lnet/minecraft/registry/entry/RegistryEntryList;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkNullRegistryEntry(class_6885<class_1792> registryEntryList, CallbackInfoReturnable<Boolean> info) {
        if (this.entry == null) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isEnchantable"}, at={@At(value="HEAD")}, cancellable=true)
    public void isEnchantableCheckNullEntry(CallbackInfoReturnable<Boolean> info) {
        if (this.entry == null) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"areItemsEqual", "areItemsAndComponentsEqual"}, at={@At(value="HEAD")}, cancellable=true)
    private static void checkEmptyStacksPrematurely(class_1799 stack, class_1799 otherStack, CallbackInfoReturnable<Boolean> info) {
        if (stack.method_7960() && otherStack.method_7960()) {
            info.setReturnValue((Object)true);
        }
    }

    @Redirect(method={"areItemsEqual", "areItemsAndComponentsEqual"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isOf(Lnet/minecraft/item/Item;)Z"))
    private static boolean isOfUseRegistryEntryCheck(class_1799 instance, class_1792 item, class_1799 left, class_1799 right) {
        return instance.method_41406(right.method_41409());
    }

    @Inject(method={"hasGlint"}, at={@At(value="HEAD")}, cancellable=true)
    public void hasGlintCheckNullEntry(CallbackInfoReturnable<Boolean> info) {
        if (this.entry == null) {
            info.setReturnValue((Object)false);
        }
    }

    @Overwrite
    public boolean method_58407(class_1282 source) {
        ImmuneToDamageComponent immuneToDamage = (ImmuneToDamageComponent)this.method_57824(ItematicDataComponentTypes.IMMUNE_TO_DAMAGE);
        return immuneToDamage == null || immuneToDamage.damage(source);
    }

    @Inject(method={"getName"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getItem()Lnet/minecraft/item/Item;")}, cancellable=true)
    private void getNameGetItemCheckNullEntry(CallbackInfoReturnable<class_2561> info) {
        if (this.entry == null) {
            info.setReturnValue((Object)class_2561.method_43473());
        }
    }

    @Redirect(method={"getTooltip"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isOf(Lnet/minecraft/item/Item;)Z"))
    private boolean isOfForFilledMapUseItemComponentCheck(class_1799 instance, class_1792 item) {
        return this.itematic$hasComponent(ItemComponentTypes.MAP_HOLDER);
    }

    @Redirect(method={"getTooltip"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/Item;appendTooltip(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/Item$TooltipContext;Ljava/util/List;Lnet/minecraft/client/item/TooltipType;)V"))
    private void appendTooltipUseRegistryEntry(class_1792 instance, class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        if (this.entry != null) {
            ((class_1792)this.entry.comp_349()).method_7851(stack, context, tooltip, type);
        }
    }

    @Redirect(method={"getTooltip"}, at=@At(value="INVOKE", target="Lnet/minecraft/registry/DefaultedRegistry;getId(Ljava/lang/Object;)Lnet/minecraft/util/Identifier;"))
    @NotNull
    private <T> class_2960 getIdUseRegistryEntry(class_7922<T> instance, T t) {
        return this.itematic$key().method_29177();
    }

    @Inject(method={"onStackClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void onStackClickedUseRegistryEntryNullCheck(class_1735 slot, class_5536 clickType, class_1657 player, CallbackInfoReturnable<Boolean> info) {
        if (this.method_7960()) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"onClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void onClickedUseRegistryEntryNullCheck(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference, CallbackInfoReturnable<Boolean> info) {
        if (this.method_7960()) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"postMine"}, at={@At(value="HEAD")}, cancellable=true)
    private void postMineUseRegistryEntryNullCheck(class_1937 world, class_2680 state, class_2338 pos, class_1657 miner, CallbackInfo info) {
        if (this.method_7960()) {
            info.cancel();
        }
    }

    @Inject(method={"damage(ILnet/minecraft/util/math/random/Random;Lnet/minecraft/server/network/ServerPlayerEntity;Ljava/lang/Runnable;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;setDamage(I)V", shift=At.Shift.AFTER)})
    private void invokeDamageToolEvent(int amount, class_5819 random, class_3222 serverPlayerEntity, Runnable breakCallback, CallbackInfo info) {
        if (this.context == null) {
            return;
        }
        this.itematic$invokeEvent(ItemEvents.DAMAGE_ITEM, this.context);
    }

    @WrapWithCondition(method={"damage(ILnet/minecraft/util/math/random/Random;Lnet/minecraft/server/network/ServerPlayerEntity;Ljava/lang/Runnable;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/advancement/criterion/ItemDurabilityChangedCriterion;trigger(Lnet/minecraft/server/network/ServerPlayerEntity;Lnet/minecraft/item/ItemStack;I)V")})
    private boolean limitDamageApplied(class_2069 instance, class_3222 player, class_1799 stack, int durability, @Local(argsOnly=true) LocalIntRef amount) {
        this.itematic$getComponent(ItemComponentTypes.DAMAGEABLE).map(c -> Math.min(c.maximumDamage((class_1799)this) - this.method_7919(), amount.get())).ifPresent(arg_0 -> ((LocalIntRef)amount).set(arg_0));
        return amount.get() != 0;
    }

    @Inject(method={"damage(ILnet/minecraft/util/math/random/Random;Lnet/minecraft/server/network/ServerPlayerEntity;Ljava/lang/Runnable;)V"}, at={@At(value="INVOKE", target="Ljava/lang/Runnable;run()V")})
    private void invokeBreakToolEvent(int amount, class_5819 random, class_3222 serverPlayerEntity, Runnable runnable, CallbackInfo info) {
        if (this.context == null) {
            return;
        }
        this.itematic$invokeEvent(ItemEvents.BREAK_ITEM, this.context);
    }

    @Redirect(method={"useOnBlock", "method_56097", "postHit", "postMine", "onCraftByPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/stat/StatType;getOrCreateStat(Ljava/lang/Object;)Lnet/minecraft/stat/Stat;"))
    private <T> class_3445<class_1792> getOrCreateStatUseRegistryEntry(class_3448<class_1792> instance, T key) {
        return instance.itematic$getOrCreateStat(this.entry);
    }

    @Overwrite
    public String toString() {
        return this.field_8031 + " " + this.itematic$key().method_29177().toString();
    }

    @Override
    public class_5321<class_1792> itematic$key() {
        if (this.entry == null) {
            return ItemKeys.AIR;
        }
        return this.entry.method_40230().orElse(ItemKeys.AIR);
    }

    @Override
    public void itematic$setComponents(class_9335 components) {
        this.field_49270 = components;
    }

    @Override
    public void itematic$tryIncrement(int count) {
        if (this.method_7960()) {
            return;
        }
        this.field_8031 = class_3532.method_15340((int)(this.field_8031 + count), (int)0, (int)this.method_7914());
    }

    @Override
    public int itematic$tryDecrement(int amount) {
        int actualAmount = Math.min(amount, this.method_7947());
        this.method_7934(actualAmount);
        return actualAmount;
    }

    @Override
    public class_1799 itematic$copyWithItem(class_6880<class_1792> item) {
        return this.itematic$copyComponentsToNewStack(item, this.field_8031);
    }

    @Override
    public class_1799 itematic$copyComponentsToNewStack(class_6880<class_1792> item, int count) {
        if (this.method_7960()) {
            return field_8037;
        }
        return this.itematic$copyComponentsToNewStackIgnoreEmpty(item, count);
    }

    @Override
    public class_1799 itematic$copyComponentsToNewStackIgnoreEmpty(class_6880<class_1792> item, int count) {
        return new class_1799(item, count, this.field_49270.method_57940());
    }

    @Override
    public boolean itematic$isOf(class_5321<class_1792> key) {
        return this.entry != null && this.entry.method_40227() && this.entry.method_40225(key);
    }

    @Override
    public void itematic$damage(int amount, ActionContext context) {
        class_3222 player;
        if (context.player(ActionContextParameter.THIS).map(class_1657::method_7337).orElse(false).booleanValue()) {
            return;
        }
        this.context = context;
        class_1297 entity = context.entity(ActionContextParameter.THIS).orElse(null);
        this.method_7956(amount, context.world().method_8409(), entity instanceof class_3222 ? (player = (class_3222)entity) : null, () -> this.onItemBroken(entity, context));
        this.context = null;
    }

    @Override
    public <T extends ItemComponent<T>> boolean itematic$hasComponent(ItemComponentType<T> type) {
        return this.entry != null && ((class_1792)this.entry.comp_349()).itematic$hasComponent(type);
    }

    @Override
    public <T extends ItemComponent<T>> Optional<T> itematic$getComponent(ItemComponentType<T> type) {
        if (this.entry == null) {
            return Optional.empty();
        }
        return ((class_1792)this.entry.comp_349()).itematic$getComponent(type);
    }

    @Override
    public boolean itematic$invokeEvent(ItemEvent event, ActionContext context) {
        if (this.entry == null) {
            return false;
        }
        if (this.activeEvents.contains(event)) {
            return false;
        }
        this.activeEvents.add(event);
        boolean result = ((class_1792)this.entry.comp_349()).itematic$invokeEvent(event, context);
        this.activeEvents.remove(event);
        return result;
    }

    @Override
    public boolean itematic$canMine(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        if (this.entry == null) {
            return true;
        }
        if (miner.method_7337() && this.method_31573(ItematicItemTags.PREVENTS_MINING_IN_CREATIVE)) {
            return false;
        }
        return ((class_1792)this.entry.comp_349()).method_7885(state, world, pos, miner);
    }

    @Override
    public boolean itematic$isNetworkSynced() {
        if (this.entry == null) {
            return false;
        }
        return ((class_1792)this.entry.comp_349()).method_16698();
    }

    @Override
    public boolean itematic$mayStartUsing(class_1937 world, class_1657 user, class_1268 hand, class_1799 stack) {
        if (this.entry == null) {
            return false;
        }
        return ((class_1792)this.entry.comp_349()).itematic$mayStartUsing(world, user, hand, stack);
    }

    @Override
    public int itematic$useDuration(class_1309 user) {
        if (!this.itematic$hasComponent(ItemComponentTypes.USEABLE)) {
            return 0;
        }
        UseDurationDataComponent useDuration = (UseDurationDataComponent)this.method_57824(ItematicDataComponentTypes.USE_DURATION);
        if (useDuration == null) {
            return 0;
        }
        return useDuration.ticks((class_1799)this, user);
    }

    @Override
    public double itematic$attackSpeedMultiplier() {
        if (!this.itematic$hasComponent(ItemComponentTypes.WEAPON)) {
            return 1.0;
        }
        return (Double)this.method_57825(ItematicDataComponentTypes.ATTACK_SPEED_MULTIPLIER, 1.0);
    }

    @Unique
    private void setFields(class_6880<class_1792> entry) {
        this.entry = entry;
        if (entry.method_40227()) {
            this.field_49270 = new class_9335(((class_1792)entry.comp_349()).method_57347());
            ((class_1792)entry.comp_349()).method_7860((class_1799)this);
        } else {
            this.field_49270 = new class_9335(class_9323.field_49584);
        }
    }

    @Unique
    private void onItemBroken(class_1297 entity, ActionContext context) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            context.slot().ifPresent(arg_0 -> ((class_1309)livingEntity).method_20235(arg_0));
        }
        this.method_7934(1);
        this.itematic$invokeEvent(ItemEvents.BREAK_ITEM, context);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (this.entry != null) {
                player.method_7259(class_3468.field_15383.itematic$getOrCreateStat(this.entry));
            }
        }
        this.method_7974(0);
    }
}

