/*
 * Decompiled with CFR 0.152.
 */
package net.errorcraft.itematic.mixin.recipe;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.errorcraft.itematic.access.recipe.BrewingRecipeRegistryAccess;
import net.errorcraft.itematic.access.recipe.BrewingRecipeRegistryBuilderAccess;
import net.errorcraft.itematic.component.PotionContentsComponentUtil;
import net.errorcraft.itematic.item.ItemKeys;
import net.errorcraft.itematic.item.component.ItemComponentTypes;
import net.errorcraft.itematic.recipe.BrewingRecipe;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1845;
import net.minecraft.class_1847;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1845.class})
public class BrewingRecipeRegistryExtender
implements BrewingRecipeRegistryAccess {
    @Unique
    private List<BrewingRecipe<class_5321<class_1792>>> itemRecipes;
    @Unique
    private List<BrewingRecipe<class_6880<class_1842>>> potionRecipes;

    @Overwrite
    private boolean method_59700(class_1799 stack) {
        return stack.itematic$hasComponent(ItemComponentTypes.POTION_HOLDER);
    }

    @Overwrite
    public boolean method_8079(class_1799 stack) {
        for (BrewingRecipe<class_5321<class_1792>> recipe : this.itemRecipes) {
            if (!stack.itematic$isOf(recipe.ingredient())) continue;
            return true;
        }
        return false;
    }

    @Overwrite
    public boolean method_8070(class_1799 input, class_1799 ingredient) {
        for (BrewingRecipe<class_5321<class_1792>> recipe : this.itemRecipes) {
            if (!input.itematic$isOf(recipe.input()) || !ingredient.itematic$isOf(recipe.ingredient())) continue;
            return true;
        }
        return false;
    }

    @Overwrite
    public boolean method_8069(class_1799 stack) {
        for (BrewingRecipe<class_6880<class_1842>> recipe : this.potionRecipes) {
            if (!stack.itematic$isOf(recipe.ingredient())) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"hasPotionRecipe"}, at={@At(value="INVOKE_ASSIGN", target="Ljava/util/List;iterator()Ljava/util/Iterator;")}, cancellable=true)
    private void hasPotionRecipeUseItemKeys(class_1799 input, class_1799 ingredient, CallbackInfoReturnable<Boolean> info, @Local Optional<class_6880<class_1842>> optional) {
        class_6880<class_1842> potion = optional.get();
        for (BrewingRecipe<class_6880<class_1842>> recipe : this.potionRecipes) {
            if (recipe.input() != potion || !ingredient.itematic$isOf(recipe.ingredient())) continue;
            info.setReturnValue((Object)true);
            return;
        }
        info.setReturnValue((Object)false);
    }

    @Overwrite
    public boolean method_20361(class_6880<class_1842> potion) {
        for (BrewingRecipe<class_6880<class_1842>> recipe : this.potionRecipes) {
            if (recipe.output() != potion) continue;
            return true;
        }
        return false;
    }

    @Redirect(method={"create"}, at=@At(value="INVOKE", target="Lnet/minecraft/recipe/BrewingRecipeRegistry;registerDefaults(Lnet/minecraft/recipe/BrewingRecipeRegistry$Builder;)V"))
    private static void registerRecipes(class_1845.class_9665 builder) {
        builder.itematic$registerItemRecipe(ItemKeys.POTION, ItemKeys.GUNPOWDER, ItemKeys.SPLASH_POTION);
        builder.itematic$registerItemRecipe(ItemKeys.SPLASH_POTION, ItemKeys.DRAGON_BREATH, ItemKeys.LINGERING_POTION);
        builder.itematic$registerWaterPotionRecipe(ItemKeys.GLISTERING_MELON_SLICE, class_1847.field_8967);
        builder.itematic$registerWaterPotionRecipe(ItemKeys.GHAST_TEAR, class_1847.field_8967);
        builder.itematic$registerWaterPotionRecipe(ItemKeys.RABBIT_FOOT, class_1847.field_8967);
        builder.itematic$registerWaterPotionRecipe(ItemKeys.BLAZE_POWDER, class_1847.field_8967);
        builder.itematic$registerWaterPotionRecipe(ItemKeys.SPIDER_EYE, class_1847.field_8967);
        builder.itematic$registerWaterPotionRecipe(ItemKeys.SUGAR, class_1847.field_8967);
        builder.itematic$registerWaterPotionRecipe(ItemKeys.MAGMA_CREAM, class_1847.field_8967);
        builder.itematic$registerWaterPotionRecipe(ItemKeys.GLOWSTONE_DUST, class_1847.field_8985);
        builder.itematic$registerWaterPotionRecipe(ItemKeys.REDSTONE, class_1847.field_8967);
        builder.itematic$registerWaterPotionRecipe(ItemKeys.NETHER_WART, class_1847.field_8999);
        builder.itematic$registerAwkwardPotionRecipe(ItemKeys.GOLDEN_CARROT, class_1847.field_8968);
        builder.itematic$registerAwkwardPotionRecipe(ItemKeys.MAGMA_CREAM, class_1847.field_8987);
        builder.itematic$registerAwkwardPotionRecipe(ItemKeys.RABBIT_FOOT, class_1847.field_8979);
        builder.itematic$registerAwkwardPotionRecipe(ItemKeys.TURTLE_HELMET, class_1847.field_8990);
        builder.itematic$registerAwkwardPotionRecipe(ItemKeys.SUGAR, class_1847.field_9005);
        builder.itematic$registerAwkwardPotionRecipe(ItemKeys.PUFFERFISH, class_1847.field_8994);
        builder.itematic$registerAwkwardPotionRecipe(ItemKeys.GLISTERING_MELON_SLICE, class_1847.field_8963);
        builder.itematic$registerAwkwardPotionRecipe(ItemKeys.SPIDER_EYE, class_1847.field_8982);
        builder.itematic$registerAwkwardPotionRecipe(ItemKeys.GHAST_TEAR, class_1847.field_8986);
        builder.itematic$registerAwkwardPotionRecipe(ItemKeys.BLAZE_POWDER, class_1847.field_8978);
        builder.itematic$registerAwkwardPotionRecipe(ItemKeys.PHANTOM_MEMBRANE, class_1847.field_8974);
        builder.itematic$registerLongPotionRecipe(class_1847.field_8968, class_1847.field_8981);
        builder.itematic$registerLongPotionRecipe(class_1847.field_8997, class_1847.field_9000);
        builder.itematic$registerLongPotionRecipe(class_1847.field_8987, class_1847.field_8969);
        builder.itematic$registerLongPotionRecipe(class_1847.field_8979, class_1847.field_8971);
        builder.itematic$registerLongPotionRecipe(class_1847.field_8996, class_1847.field_8989);
        builder.itematic$registerLongPotionRecipe(class_1847.field_8990, class_1847.field_8988);
        builder.itematic$registerLongPotionRecipe(class_1847.field_9005, class_1847.field_8983);
        builder.itematic$registerLongPotionRecipe(class_1847.field_8994, class_1847.field_9001);
        builder.itematic$registerLongPotionRecipe(class_1847.field_8982, class_1847.field_9002);
        builder.itematic$registerLongPotionRecipe(class_1847.field_8986, class_1847.field_9003);
        builder.itematic$registerLongPotionRecipe(class_1847.field_8978, class_1847.field_8965);
        builder.itematic$registerLongPotionRecipe(class_1847.field_8975, class_1847.field_8970);
        builder.itematic$registerLongPotionRecipe(class_1847.field_8974, class_1847.field_8964);
        builder.itematic$registerStrongPotionRecipe(class_1847.field_8979, class_1847.field_8998);
        builder.itematic$registerStrongPotionRecipe(class_1847.field_8996, class_1847.field_8976);
        builder.itematic$registerStrongPotionRecipe(class_1847.field_8990, class_1847.field_8977);
        builder.itematic$registerStrongPotionRecipe(class_1847.field_9005, class_1847.field_8966);
        builder.itematic$registerStrongPotionRecipe(class_1847.field_8963, class_1847.field_8980);
        builder.itematic$registerStrongPotionRecipe(class_1847.field_9004, class_1847.field_8973);
        builder.itematic$registerStrongPotionRecipe(class_1847.field_8982, class_1847.field_8972);
        builder.itematic$registerStrongPotionRecipe(class_1847.field_8986, class_1847.field_8992);
        builder.itematic$registerStrongPotionRecipe(class_1847.field_8978, class_1847.field_8993);
        builder.itematic$registerNegatingPotionRecipe(class_1847.field_8968, class_1847.field_8997);
        builder.itematic$registerNegatingPotionRecipe(class_1847.field_8981, class_1847.field_9000);
        builder.itematic$registerNegatingPotionRecipe(class_1847.field_8979, class_1847.field_8996);
        builder.itematic$registerNegatingPotionRecipe(class_1847.field_8971, class_1847.field_8989);
        builder.itematic$registerNegatingPotionRecipe(class_1847.field_9005, class_1847.field_8996);
        builder.itematic$registerNegatingPotionRecipe(class_1847.field_8983, class_1847.field_8989);
        builder.itematic$registerNegatingPotionRecipe(class_1847.field_8963, class_1847.field_9004);
        builder.itematic$registerNegatingPotionRecipe(class_1847.field_8980, class_1847.field_8973);
        builder.itematic$registerNegatingPotionRecipe(class_1847.field_8982, class_1847.field_9004);
        builder.itematic$registerNegatingPotionRecipe(class_1847.field_9002, class_1847.field_9004);
        builder.itematic$registerNegatingPotionRecipe(class_1847.field_8972, class_1847.field_8973);
        builder.itematic$registerNegatingPotionRecipe(class_1847.field_8991, class_1847.field_8975);
    }

    @Override
    public void itematic$setItemRecipes(List<BrewingRecipe<class_5321<class_1792>>> itemRecipes) {
        this.itemRecipes = itemRecipes;
    }

    @Override
    public void itematic$setPotionRecipes(List<BrewingRecipe<class_6880<class_1842>>> potionRecipes) {
        this.potionRecipes = potionRecipes;
    }

    @Override
    public class_1799 itematic$craft(class_1799 ingredient, class_1799 input, class_1937 world) {
        if (input.method_7960()) {
            return input;
        }
        Optional optionalPotion = ((class_1844)input.method_57825(class_9334.field_49651, (Object)class_1844.field_49274)).comp_2378();
        if (optionalPotion.isEmpty()) {
            return input;
        }
        class_6880 potion = (class_6880)optionalPotion.get();
        for (BrewingRecipe<class_5321<class_1792>> brewingRecipe : this.itemRecipes) {
            if (!input.itematic$isOf(brewingRecipe.input()) || !ingredient.itematic$isOf(brewingRecipe.ingredient())) continue;
            return PotionContentsComponentUtil.setPotion(world.itematic$createStack(brewingRecipe.output()), (class_6880<class_1842>)potion);
        }
        for (BrewingRecipe<class_5321<class_1792>> brewingRecipe : this.potionRecipes) {
            if (brewingRecipe.input() != potion || !ingredient.itematic$isOf(brewingRecipe.ingredient())) continue;
            return PotionContentsComponentUtil.setPotion(new class_1799(input.method_41409()), (class_6880<class_1842>)((class_6880)brewingRecipe.output()));
        }
        return input;
    }

    @Mixin(value={class_1845.class_9665.class})
    public static class BuilderExtender
    implements BrewingRecipeRegistryBuilderAccess {
        @Unique
        private final List<BrewingRecipe<class_5321<class_1792>>> itemRecipes = new ArrayList<BrewingRecipe<class_5321<class_1792>>>();
        @Unique
        private final List<BrewingRecipe<class_6880<class_1842>>> potionRecipes = new ArrayList<BrewingRecipe<class_6880<class_1842>>>();

        @ModifyReturnValue(method={"build"}, at={@At(value="TAIL")})
        private class_1845 setRecipes(class_1845 original) {
            original.itematic$setItemRecipes(List.copyOf(this.itemRecipes));
            original.itematic$setPotionRecipes(List.copyOf(this.potionRecipes));
            return original;
        }

        @Override
        public void itematic$registerItemRecipe(class_5321<class_1792> from, class_5321<class_1792> ingredient, class_5321<class_1792> to) {
            this.itemRecipes.add(new BrewingRecipe<class_5321<class_1792>>(from, ingredient, to));
        }

        @Override
        public void itematic$registerWaterPotionRecipe(class_5321<class_1792> key, class_6880<class_1842> output) {
            this.potionRecipes.add(new BrewingRecipe<class_6880<class_1842>>(class_1847.field_8991, key, output));
        }

        @Override
        public void itematic$registerAwkwardPotionRecipe(class_5321<class_1792> key, class_6880<class_1842> output) {
            this.potionRecipes.add(new BrewingRecipe<class_6880<class_1842>>(class_1847.field_8999, key, output));
        }

        @Override
        public void itematic$registerLongPotionRecipe(class_6880<class_1842> input, class_6880<class_1842> output) {
            this.potionRecipes.add(new BrewingRecipe<class_6880<class_1842>>(input, ItemKeys.REDSTONE, output));
        }

        @Override
        public void itematic$registerStrongPotionRecipe(class_6880<class_1842> input, class_6880<class_1842> output) {
            this.potionRecipes.add(new BrewingRecipe<class_6880<class_1842>>(input, ItemKeys.GLOWSTONE_DUST, output));
        }

        @Override
        public void itematic$registerNegatingPotionRecipe(class_6880<class_1842> input, class_6880<class_1842> output) {
            this.potionRecipes.add(new BrewingRecipe<class_6880<class_1842>>(input, ItemKeys.FERMENTED_SPIDER_EYE, output));
        }
    }
}

